/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.registries;

import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonCorridor;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonDeco;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.util.PieceConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleFunction;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class DesertDungeonCorridorRegistry {
    private static final List<DesertDungeonCorridor> corridors = new ArrayList<DesertDungeonCorridor>();
    private static DesertDungeonCorridorRegistry INSTANCE;

    private DesertDungeonCorridorRegistry() {
    }

    public static DesertDungeonCorridorRegistry get() {
        if (INSTANCE == null) {
            INSTANCE = new DesertDungeonCorridorRegistry();
        }
        return INSTANCE;
    }

    public static DesertDungeonCorridor register(String name, PieceConnection entrance, PieceConnection exit, Tuple<DesertDungeonDeco, Tuple<Vec3i, Rotation>>[] deco) {
        DesertDungeonCorridor corridor = new DesertDungeonCorridor(name, entrance, exit, deco);
        corridors.add(corridor);
        return corridor;
    }

    public static DesertDungeonCorridor getRandom() {
        Random rand = new Random();
        return corridors.get(rand.nextInt(corridors.size()));
    }

    public static DesertDungeonCorridor getRandom(int bedrockDistance, int xBound, int zBound, Direction direc) {
        HashMap<DesertDungeonCorridor, Double> chanceMapBound = new HashMap<DesertDungeonCorridor, Double>();
        Vec3 boundVec = new Vec3((double)xBound, 0.0, (double)zBound);
        for (DesertDungeonCorridor piece : corridors) {
            Vec3 boundVecMulAdd = boundVec.m_82559_(new Vec3((double)piece.getAngle().m_55954_(direc).m_122436_().m_123341_(), 0.0, (double)piece.getAngle().m_55954_(direc).m_122436_().m_123343_()));
            double d = Math.max(-1.0 * (boundVecMulAdd.f_82479_ + boundVecMulAdd.f_82481_ - 40.0), 0.0);
            chanceMapBound.put(piece, d);
        }
        DoubleFunction<Double> f = x -> Math.pow((x + 25.0) / 25.0, (double)bedrockDistance / 32.0);
        HashMap<DesertDungeonCorridor, Double> chanceMapHight = new HashMap<DesertDungeonCorridor, Double>();
        for (DesertDungeonCorridor piece : corridors) {
            chanceMapHight.put(piece, f.apply(piece.getDownwardsAngle()));
        }
        double scale = 0.0;
        HashMap<DesertDungeonCorridor, Double> chanceMap = new HashMap<DesertDungeonCorridor, Double>();
        for (DesertDungeonCorridor piece : corridors) {
            chanceMap.put(piece, (Double)chanceMapHight.get(piece) * (Double)chanceMapBound.get(piece));
            scale += ((Double)chanceMap.get(piece)).doubleValue();
        }
        for (DesertDungeonCorridor piece : corridors) {
            chanceMap.replace(piece, (Double)chanceMap.get(piece) / scale);
        }
        Random random = new Random();
        double randDouble = random.nextDouble();
        double passedChance = 0.0;
        for (DesertDungeonCorridor piece : corridors) {
            if (!((passedChance += ((Double)chanceMap.get(piece)).doubleValue()) > randDouble)) continue;
            return piece;
        }
        return DesertDungeonCorridorRegistry.getRandom();
    }
}

