/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.structures.desert_dungeon.pieces;

import com.becks.uniquedungeons.common.structures.desert_dungeon.DesertDungeonGenerationConfig;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.DesertDungeonPiece;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.registries.DesertDungeonEndRegistry;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.registries.DesertDungeonStartRegistry;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.ADesertDungeonPiece;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonDeco;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonEnd;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonJunction;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonRoom;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonStart;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.util.DesertDungeonMidPiecesUtil;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.util.PieceConnection;
import com.becks.uniquedungeons.util.BBHelper;
import com.becks.uniquedungeons.util.DirectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DesertDungeonPieces {
    static final SectionGenerator GENERATOR_1 = new SectionGenerator(){

        @Override
        public void init() {
        }

        @Override
        public int generate(ChunkGenerator chunkGenerator, LevelHeightAccessor levelHeightAccessor, RandomState randomState, StructureTemplateManager manager, int pieceLimit, int roomLimit, int junktionLimit, DesertDungeonPiece lastPiece, ADesertDungeonPiece lastPieceType, BlockPos startPos, BlockPos absoluteStart, List<Tuple<StructurePiece, Boolean>> pieces, List<DesertDungeonRoom> usedRooms, RandomSource random) {
            int recRoomLimit = roomLimit;
            int recJunktionLimit = junktionLimit;
            if (pieceLimit <= 0) {
                return 0;
            }
            Rotation rotation = lastPiece.m_226913_().m_74404_();
            boolean allDirectionsSuccess = true;
            block0: for (PieceConnection c : lastPieceType.getExits()) {
                if (!allDirectionsSuccess) {
                    return -1;
                }
                Direction rotatedD = rotation.m_55954_(c.getDirection());
                int tries = 0;
                int recSuccess = -1;
                DesertDungeonPiece piece = null;
                while (piece == null || recSuccess == -1) {
                    if (piece != null) {
                        DesertDungeonPieces.removeHelper(pieces, piece);
                    }
                    if (tries > 10) {
                        allDirectionsSuccess = false;
                        continue block0;
                    }
                    DesertDungeonEnd newType = pieceLimit <= 1 ? DesertDungeonEndRegistry.getRandom() : DesertDungeonMidPiecesUtil.getRandom(usedRooms, lastPieceType, DesertDungeonGenerationConfig.CORRIDOR_PERCENTAGE, DesertDungeonGenerationConfig.ROOM_PERCENTAGE, DesertDungeonGenerationConfig.JUNKTION_PERCENTAGE, recRoomLimit > 0 && (double)pieceLimit <= 0.7 * (double)DesertDungeonGenerationConfig.NUM_PIECES_PER_REC && Math.abs(startPos.m_123341_() - absoluteStart.m_123341_()) < 40 && startPos.m_123342_() >= -40, recJunktionLimit > 0 && Math.abs(startPos.m_123341_() - absoluteStart.m_123341_()) < 40 && startPos.m_123342_() >= -40, startPos.m_123342_(), startPos.m_123341_() - absoluteStart.m_123341_(), startPos.m_123343_() - absoluteStart.m_123343_(), rotatedD);
                    Vec3i offsetsVec = Rotation.CLOCKWISE_90.m_55954_(rotatedD).m_122436_().m_142393_(-(c.getHorizontalOffset() - 13)).m_121955_(new Vec3i(0, 1, 0).m_142393_(c.getVertikalOffset() - 13));
                    PieceConnection newTypeEntrance = newType.getEntrance();
                    Rotation matchRotation = DirectionHelper.getRotation(c.getDirection(), newTypeEntrance.getDirection());
                    Rotation actualRotation = rotation.m_55952_(matchRotation);
                    Vec3i cubeOffsets = DirectionHelper.getOffsets(rotation, matchRotation, rotatedD);
                    Vec3i secondaryOffsetsVec = Rotation.CLOCKWISE_90.m_55954_(rotatedD).m_122436_().m_142393_(-(newTypeEntrance.getHorizontalOffset() - 13)).m_121955_(new Vec3i(0, 1, 0).m_142393_(-(newTypeEntrance.getVertikalOffset() - 13)));
                    BlockPos newPos = startPos.m_121955_(cubeOffsets).m_121955_(offsetsVec).m_121955_(secondaryOffsetsVec);
                    piece = newType.get(manager, newPos, actualRotation);
                    if (!BBHelper.intersectOneOfOrGround(chunkGenerator, levelHeightAccessor, randomState, BBHelper.getToCheck(pieces), piece.m_73547_())) {
                        pieces.add((Tuple<StructurePiece, Boolean>)new Tuple((Object)piece, (Object)true));
                        if (newType instanceof DesertDungeonRoom) {
                            usedRooms.add((DesertDungeonRoom)((Object)newType));
                            --recRoomLimit;
                        } else if (newType instanceof DesertDungeonJunction) {
                            --recJunktionLimit;
                        }
                        recSuccess = DesertDungeonPieces.recursiveChildren(chunkGenerator, levelHeightAccessor, randomState, manager, this, --pieceLimit, recRoomLimit, recJunktionLimit, piece, newType, newPos, absoluteStart, pieces, usedRooms, random, tries);
                        if (recSuccess >= 0) {
                            lastPiece.addChild(piece);
                            for (Tuple<DesertDungeonDeco, Tuple<Vec3i, Rotation>> t : newType.getDeco()) {
                                Rotation decoRotation = ((Rotation)((Tuple)t.m_14419_()).m_14419_()).m_55952_(actualRotation);
                                Vec3i relativeOffset = DirectionHelper.getRotatedVec((Vec3i)((Tuple)t.m_14419_()).m_14418_(), actualRotation);
                                DesertDungeonPiece decoPiece = DesertDungeonPieces.addHelper(pieces, ((DesertDungeonDeco)t.m_14418_()).get(manager, newPos.m_121955_(relativeOffset), decoRotation), false);
                                piece.addChild(decoPiece);
                            }
                        } else {
                            if (newType instanceof DesertDungeonRoom) {
                                usedRooms.remove(newType);
                            }
                            DesertDungeonPieces.removeHelper(pieces, piece);
                        }
                        if (recSuccess == -2) {
                            allDirectionsSuccess = false;
                        }
                    }
                    ++tries;
                }
            }
            if (!allDirectionsSuccess) {
                return -1;
            }
            return 1;
        }
    };

    static DesertDungeonPiece addPiece(StructureTemplateManager pStructureTemplateManager, DesertDungeonPiece pPiece, BlockPos pStartPos, String pName, Rotation pRotation, boolean pOverwrite) {
        DesertDungeonPiece pieces = new DesertDungeonPiece(pStructureTemplateManager, pName, pPiece.m_226912_(), pRotation, pOverwrite);
        BlockPos blockpos = pPiece.m_226911_().m_74566_(pPiece.m_226913_(), pStartPos, pieces.m_226913_(), BlockPos.f_121853_);
        pieces.m_6324_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
        return pieces;
    }

    public static void startGeneration(ChunkGenerator chunkGenerator, LevelHeightAccessor levelHeightAccessor, RandomState randomState, StructureTemplateManager pStructureTemplateManager, BlockPos pStartPos, Rotation pRotation, List<Tuple<StructurePiece, Boolean>> pPieces, RandomSource pRandom) {
        GENERATOR_1.init();
        DesertDungeonStart startType = DesertDungeonStartRegistry.getRandom();
        BlockPos pStartPosYCompensated = pStartPos.m_6630_(startType.getGenerationYOffset());
        DesertDungeonPiece piece = DesertDungeonPieces.addHelper(pPieces, startType.get(pStructureTemplateManager, pStartPosYCompensated, pRotation), true);
        ArrayList<DesertDungeonRoom> usedRooms = new ArrayList<DesertDungeonRoom>();
        if (DesertDungeonPieces.recursiveChildren(chunkGenerator, levelHeightAccessor, randomState, pStructureTemplateManager, GENERATOR_1, DesertDungeonGenerationConfig.NUM_PIECES_PER_REC, DesertDungeonGenerationConfig.NUM_ROOMS_PER_REC, DesertDungeonGenerationConfig.NUM_JUNC_PER_REC, piece, startType, pStartPosYCompensated, pStartPosYCompensated, pPieces, usedRooms, pRandom, 0) == -2) {
            pPieces.clear();
        }
    }

    static DesertDungeonPiece addHelper(List<Tuple<StructurePiece, Boolean>> pPieces, DesertDungeonPiece pPiece, boolean checkIntersect) {
        pPieces.add((Tuple<StructurePiece, Boolean>)new Tuple((Object)pPiece, (Object)checkIntersect));
        return pPiece;
    }

    static void removeHelper(List<Tuple<StructurePiece, Boolean>> pPieces, DesertDungeonPiece pPiece) {
        pPiece.callForAllRecursiveChildren(p -> {
            for (Tuple t : pPieces) {
                if (!((StructurePiece)t.m_14418_()).equals(p)) continue;
                pPieces.remove(t);
                break;
            }
        });
        for (Tuple<StructurePiece, Boolean> t : pPieces) {
            if (!((StructurePiece)t.m_14418_()).equals((Object)pPiece)) continue;
            pPieces.remove(t);
            break;
        }
    }

    static int recursiveChildren(ChunkGenerator chunkGenerator, LevelHeightAccessor levelHeightAccessor, RandomState randomState, StructureTemplateManager pStructureTemplateManager, SectionGenerator pSectionGenerator, int pieceLimit, int roomLimit, int junktionLimit, DesertDungeonPiece pPiece, ADesertDungeonPiece lastPieceType, BlockPos pStartPos, BlockPos absoluteStart, List<Tuple<StructurePiece, Boolean>> pPieces, List<DesertDungeonRoom> usedRooms, RandomSource pRandom, int collisionCheckLimiter) {
        if (collisionCheckLimiter > 10) {
            return -2;
        }
        int generated = pSectionGenerator.generate(chunkGenerator, levelHeightAccessor, randomState, pStructureTemplateManager, pieceLimit, roomLimit, junktionLimit, pPiece, lastPieceType, pStartPos, absoluteStart, pPieces, usedRooms, pRandom);
        if (generated == -2) {
            return -1;
        }
        return generated;
    }

    static interface SectionGenerator {
        public void init();

        public int generate(ChunkGenerator var1, LevelHeightAccessor var2, RandomState var3, StructureTemplateManager var4, int var5, int var6, int var7, DesertDungeonPiece var8, ADesertDungeonPiece var9, BlockPos var10, BlockPos var11, List<Tuple<StructurePiece, Boolean>> var12, List<DesertDungeonRoom> var13, RandomSource var14);
    }
}

