/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.stackCooldowns;

import com.becks.uniquedungeons.common.stackCooldowns.StackCooldownUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundStackCooldownPacket {
    private final ItemStack stack;
    private final int duration;
    private boolean handled = false;

    public ClientboundStackCooldownPacket(ItemStack stack, int pDuration) {
        this.stack = stack;
        this.duration = pDuration;
    }

    public ClientboundStackCooldownPacket(FriendlyByteBuf pBuffer) {
        this.stack = pBuffer.m_130267_();
        this.duration = pBuffer.m_130242_();
    }

    public void toBytes(FriendlyByteBuf pBuffer) {
        pBuffer.writeItemStack(this.stack, false);
        pBuffer.m_130130_(this.duration);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> StackCooldownUtils.updateClientCooldowns(this));
        this.handled = true;
        ctx.get().setPacketHandled(true);
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public int getDuration() {
        return this.duration;
    }
}

