/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.items.artifacts;

import com.becks.uniquedungeons.common.entities.SonicBoomProjectile;
import com.becks.uniquedungeons.common.items.artifacts.abstracts.ArtifactItemBow;
import com.becks.uniquedungeons.core.init.EntityInit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class SonicBow
extends ArtifactItemBow {
    public static final Predicate<ItemStack> ECHO_SHARD = p_43017_ -> p_43017_.m_150930_(Items.f_220224_);

    public SonicBow(Item.Properties pProperties) {
        super(pProperties);
    }

    public Predicate<ItemStack> m_6437_() {
        return ECHO_SHARD;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            ItemStack itemstack = this.getProjectile(player, pStack);
            int i = this.m_8105_(pStack) - pTimeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (!itemstack.m_41619_() ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() && i >= 20) {
                Vec3 pos = player.m_146892_();
                if (!pLevel.f_46443_) {
                    Vec3 look = player.m_20154_().m_82541_();
                    SonicBoomProjectile arrow = new SonicBoomProjectile((EntityType<SonicBoomProjectile>)((EntityType)EntityInit.SONIC_BOOM_PROJECTILE.get()), (LivingEntity)player, pLevel, pos);
                    arrow.m_6034_(pos.f_82479_ + look.m_82490_((double)-0.1).f_82479_, pos.f_82480_ + look.m_82490_((double)-0.1).f_82480_, pos.f_82481_ + look.m_82490_((double)-0.1).f_82481_);
                    arrow.m_20256_(look.m_82490_(2.5));
                    pLevel.m_7967_((Entity)arrow);
                    itemstack.m_41774_(1);
                    if (itemstack.m_41619_()) {
                        player.m_150109_().m_36057_(itemstack);
                    }
                    pStack.m_41622_(1, (LivingEntity)player, p_40665_ -> p_40665_.m_21190_(player.m_7655_()));
                }
                pLevel.m_5594_(null, new BlockPos(pos), SoundEvents.f_215772_, SoundSource.PLAYERS, 5.0f, 1.0f);
            }
        }
    }

    public ItemStack getProjectile(Player player, ItemStack pShootable) {
        if (!(pShootable.m_41720_() instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
        ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)player, (Predicate)predicate);
        if (!itemstack.m_41619_()) {
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)pShootable, (ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6437_();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack1 = player.m_150109_().m_8020_(i);
            if (!predicate.test(itemstack1)) continue;
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)pShootable, (ItemStack)itemstack1);
        }
        return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)pShootable, (ItemStack)(player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_220224_) : ItemStack.f_41583_));
    }

    @Override
    public Collection<Component> generateInfoLoreText(ItemStack stack, Level level) {
        ArrayList<Component> components = new ArrayList<Component>();
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (!Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.shift_for_more").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.sonic_bow.lore").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.repair").m_130940_(ChatFormatting.WHITE).m_7220_(this.getRepairItem().m_7626_(this.getRepairItem().m_7968_())));
        }
        return components;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_220224_;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }
}

