/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.items.artifacts;

import com.becks.uniquedungeons.common.entities.AmethystProjectile;
import com.becks.uniquedungeons.common.items.artifacts.abstracts.ArtifactItemShield;
import com.becks.uniquedungeons.core.init.EntityInit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AmethystShield
extends ArtifactItemShield {
    private static final String DAMAGE_STACKS_KEY = "uniquedungeons.damageStacks";
    private static final Function<Float, Float> damageMultiplierFunction = m -> Float.valueOf(1.0f + m.floatValue() * 0.125f);
    private static final int MAX_DAMAGE_STACK = 10;
    private static final double SPREAD = 1.0;

    public AmethystShield(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public Collection<Component> generateInfoLoreText(ItemStack stack, Level level) {
        ArrayList<Component> components = new ArrayList<Component>();
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound == null || !nbtTagCompound.m_128441_("uniquedungeons.blood")) {
            this.addDamegeStacks(stack, 0);
        }
        components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.amethyst_shield.damage_stacks").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)("" + nbtTagCompound.m_128451_(DAMAGE_STACKS_KEY))).m_130940_(ChatFormatting.DARK_RED)));
        if (!Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.shift_for_more").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.amethyst_shield.lore").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.repair").m_130940_(ChatFormatting.WHITE).m_7220_(this.getRepairItem().m_7626_(this.getRepairItem().m_7968_())));
        }
        return components;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_151049_;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        this.castProjectiles(pStack, (Entity)pLivingEntity, pLevel);
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    private boolean castProjectiles(ItemStack stack, Entity source, Level level) {
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_(DAMAGE_STACKS_KEY)) {
            Random random = new Random();
            int currentStacks = nbtTagCompound.m_128451_(DAMAGE_STACKS_KEY);
            Vec3 look = source.m_20154_();
            look.m_82541_();
            Vec3 pos = source.m_146892_().m_82520_(0.0, -0.75, 0.0);
            for (int i = currentStacks; i > 0; --i) {
                Vec3 deltaOffset = new Vec3((random.nextDouble() - 0.5) * 1.0, (random.nextDouble() - 0.5) * 1.0, (random.nextDouble() - 0.5) * 1.0);
                AmethystProjectile arrow = new AmethystProjectile((EntityType<AmethystProjectile>)((EntityType)EntityInit.AMETHYST_PROJECTILE.get()), (LivingEntity)source, level, damageMultiplierFunction.apply(Float.valueOf(currentStacks)).floatValue());
                arrow.m_6034_(pos.f_82479_ + look.m_82490_((double)-0.1).f_82479_, pos.f_82480_ + look.m_82490_((double)-0.1).f_82480_, pos.f_82481_ + look.m_82490_((double)-0.1).f_82481_);
                arrow.m_20256_(look.m_82490_(1.5).m_82549_(deltaOffset));
                level.m_7967_((Entity)arrow);
            }
            nbtTagCompound.m_128473_(DAMAGE_STACKS_KEY);
            nbtTagCompound.m_128405_(DAMAGE_STACKS_KEY, 0);
            stack.m_41751_(nbtTagCompound);
            return true;
        }
        this.addDamegeStacks(stack, 0);
        return false;
    }

    public void addDamegeStacks(ItemStack stack, int damageStacks) {
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_(DAMAGE_STACKS_KEY)) {
            int currentStacks = nbtTagCompound.m_128451_(DAMAGE_STACKS_KEY);
            damageStacks = Math.min(currentStacks + damageStacks, 10);
            nbtTagCompound.m_128473_(DAMAGE_STACKS_KEY);
            nbtTagCompound.m_128405_(DAMAGE_STACKS_KEY, damageStacks);
            stack.m_41751_(nbtTagCompound);
            return;
        }
        if (nbtTagCompound == null) {
            nbtTagCompound = new CompoundTag();
        }
        nbtTagCompound.m_128405_(DAMAGE_STACKS_KEY, 0);
        stack.m_41751_(nbtTagCompound);
    }
}

