/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.entities;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class AmethystProjectile
extends Projectile {
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(AmethystProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.m_135353_(AmethystProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float DAMAGE = 5.0f;
    private float damageMultiplier = 1.0f;
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds = new IntOpenHashSet(5);
    private static final int LIFE_TIME = 100;
    private int timeAlive = 0;

    public AmethystProjectile(EntityType<AmethystProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_5602_((Entity)pShooter);
    }

    public AmethystProjectile(EntityType<AmethystProjectile> pEntityType, LivingEntity pShooter, Level pLevel, float damageMultiplier) {
        super(pEntityType, pLevel);
        this.m_5602_((Entity)pShooter);
        this.damageMultiplier = damageMultiplier;
    }

    public AmethystProjectile(EntityType<AmethystProjectile> amethystProjectileEntityType, Level level) {
        super(amethystProjectileEntityType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(PIERCE_LEVEL, (Object)0);
    }

    public void m_8119_() {
        Vec3 vec33;
        Vec3 vec32;
        BlockHitResult hitresult;
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        ++this.timeAlive;
        if (this.timeAlive >= 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!(blockstate = this.f_19853_.m_8055_(blockpos = this.m_20183_())).m_60795_() && !(voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.m_20095_();
        }
        if ((hitresult = this.f_19853_.m_45547_(new ClipContext(vec32 = this.m_20182_(), vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
            vec33 = hitresult.m_82450_();
        }
        EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33);
        while (entityhitresult != null) {
            entityhitresult.m_82443_();
            hitresult = entityhitresult;
            if (hitresult.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)hitresult).m_82443_();
                Entity entity1 = this.m_37282_();
                if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                    hitresult = null;
                    entityhitresult = null;
                }
            }
            if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_((HitResult)hitresult);
                this.f_19812_ = true;
            }
            entityhitresult = this.findHitEntity(vec32, vec33);
        }
        vec3 = this.m_20184_();
        double d5 = vec3.f_82479_;
        double d6 = vec3.f_82480_;
        double d1 = vec3.f_82481_;
        double d7 = this.m_20185_() + d5;
        double d2 = this.m_20186_() + d6;
        double d3 = this.m_20189_() + d1;
        this.m_6034_(d7, d2, d3);
        this.m_20101_();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_);
    }

    protected void m_5790_(EntityHitResult pResult) {
        DamageSource damagesource;
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        if (this.piercingIgnoreEntityIds == null) {
            this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
        }
        this.piercingIgnoreEntityIds.add(entity.m_19879_());
        Entity entity1 = this.m_37282_();
        if (entity1 == null) {
            damagesource = DamageSource.m_19367_((Entity)this, (Entity)this);
        } else {
            damagesource = DamageSource.m_19367_((Entity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, 5.0f * this.damageMultiplier)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.f_19853_.f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                if (entity1 != null && livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
            }
        }
    }

    protected boolean m_5603_(Entity p_36743_) {
        return super.m_5603_(p_36743_) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(p_36743_.m_19879_()));
    }
}

