/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock;

import com.becks.uniquedungeons.client.render.BoxHighlightRender;
import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.ItemBoxBlock.ItemBox;
import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.SelectionBox;
import com.becks.uniquedungeons.util.DirectionHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public abstract class MultiHighlightBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    protected MultiHighlightBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
        this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public abstract Collection<SelectionBox> getBoxes();

    public abstract BlockEntityType<? extends BlockEntity> getBlockEntityType();

    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack matrixStack, MultiBufferSource buffers, Vec3 renderPos) {
        SelectionBox selection = MultiHighlightBlock.getPlayerSelection(this.getBoxes(), this.getBlockEntityType(), (BlockGetter)level, pos, player, rayTrace);
        if (selection != null) {
            boolean puttable = selection instanceof ItemBox && ((ItemBox)selection).puttable(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_());
            BoxHighlightRender.drawBox(matrixStack, Shapes.m_83064_((AABB)DirectionHelper.rotateAABBblockCenterRelated(selection.getShape().m_83215_(), DirectionHelper.getRotation((Direction)level.m_8055_(pos).m_61143_((Property)FACING), Direction.SOUTH))), buffers, pos, renderPos, puttable ? 0.0f : 1.0f, puttable ? 1.0f : 0.0f, 0.0f, 0.4f);
            return true;
        }
        return false;
    }

    protected static SelectionBox getPlayerSelection(Collection<SelectionBox> boxes, BlockEntityType<? extends BlockEntity> blockEntityType, BlockGetter level, BlockPos pos, Player player, BlockHitResult result) {
        return level.m_141902_(pos, blockEntityType).map(block -> {
            Vec3 hit = result.m_82450_();
            for (SelectionBox b : boxes) {
                AABB selectionAABB = DirectionHelper.rotateAABBblockCenterRelated(b.getAabb(), DirectionHelper.getRotation((Direction)level.m_8055_(pos).m_61143_((Property)FACING), Direction.SOUTH)).m_82338_(pos);
                if (!selectionAABB.m_82390_(hit)) continue;
                return b;
            }
            return null;
        }).orElse(null);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public boolean m_6724_(BlockState p_49921_) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_7820_().equals((Object)Direction.UP) || context.m_7820_().equals((Object)Direction.DOWN) ? Direction.NORTH : context.m_7820_().m_122424_()));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }
}

