/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.artifact_unlock;

import com.becks.uniquedungeons.common.items.artifacts.abstracts.ArtifactItem;
import com.becks.uniquedungeons.core.init.itemInit.ArtifactInit;
import com.becks.uniquedungeons.network.packets.PaketSyncUnlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerUnlockData {
    private final List<ArtifactItem> knownArtifacts = new ArrayList<ArtifactItem>();

    public void saveToNBT(CompoundTag nbt) {
        CompoundTag artifactTag = new CompoundTag();
        for (int i = 0; i < this.knownArtifacts.size(); ++i) {
            ArtifactItem artifact = this.knownArtifacts.get(i);
            artifactTag.m_128359_("artifact" + i, this.knownArtifacts.get(i).toString());
        }
        artifactTag.m_128405_("size", this.knownArtifacts.size());
        nbt.m_128365_("knownArtifacts", (Tag)artifactTag);
    }

    public void loadFromNBT(CompoundTag nbt) {
        CompoundTag artifactTag = nbt.m_128469_("knownArtifacts");
        this.knownArtifacts.clear();
        for (int i = 0; i < artifactTag.m_128451_("size"); ++i) {
            String compoundString = artifactTag.m_128461_("artifact" + i);
            ArtifactItem artifact = ArtifactInit.lookUp(compoundString);
            this.knownArtifacts.add(artifact);
        }
    }

    public boolean unlock(ArtifactItem artifact) {
        if (!this.knownArtifacts.contains(artifact)) {
            this.knownArtifacts.add(artifact);
        }
        return true;
    }

    public boolean knows(ArtifactItem artifact) {
        for (ArtifactItem t : this.knownArtifacts) {
            if (!t.equals(artifact)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void sync(PaketSyncUnlock paket) {
        this.loadFromNBT(paket.getTag());
    }
}

