/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons;

import com.becks.uniquedungeons.client.model.AmethystProjectileModel;
import com.becks.uniquedungeons.client.render.AmethystProjectileRenderer;
import com.becks.uniquedungeons.client.render.ClientRenderEventHandler;
import com.becks.uniquedungeons.client.render.CrystalArrowRenderer;
import com.becks.uniquedungeons.client.render.SonicBoomProjectileRenderer;
import com.becks.uniquedungeons.common.artifact_unlock.ArtifactUnlockServer;
import com.becks.uniquedungeons.common.blocks.lockPedestal.LockPedestalRenderer;
import com.becks.uniquedungeons.common.blocks.pedestal.PedestalRenderer;
import com.becks.uniquedungeons.core.init.BlockEntityInit;
import com.becks.uniquedungeons.core.init.BlockInit;
import com.becks.uniquedungeons.core.init.EntityInit;
import com.becks.uniquedungeons.core.init.PotionsInit;
import com.becks.uniquedungeons.core.init.itemInit.ArtifactInit;
import com.becks.uniquedungeons.core.init.itemInit.GeneralItemInit;
import com.becks.uniquedungeons.core.init.structureInit.StructureInit;
import com.becks.uniquedungeons.core.init.structureInit.StructurePieceInit;
import com.becks.uniquedungeons.core.init.structureInit.desert_dungeon.DesertDungeonInit;
import com.becks.uniquedungeons.network.Network;
import com.becks.uniquedungeons.network.eventhandling.DamageEventHandler;
import com.becks.uniquedungeons.network.eventhandling.DeathEventHandler;
import com.becks.uniquedungeons.network.proxy.ClientProxy;
import com.becks.uniquedungeons.network.proxy.Proxy;
import com.becks.uniquedungeons.network.proxy.ServerProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="uniquedungeons")
public class UniqueDungeons {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "uniquedungeons";
    public static Proxy proxy = (Proxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public UniqueDungeons() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::commonSetup);
        GeneralItemInit.ITEMS.register(bus);
        ArtifactInit.ARTIFACTS.register(bus);
        BlockInit.BLOCKS.register(bus);
        BlockEntityInit.BLOCK_ENTITIES.register(bus);
        PotionsInit.POTIONS.register(bus);
        EntityInit.ENTITIES.register(bus);
        StructureInit.STRUCTURE_TYPE.register(bus);
        StructurePieceInit.STRUCTURE_PIECES.register(bus);
        DesertDungeonInit.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.register(ClientModEvents.class));
        forgeBus.register((Object)this);
        forgeBus.register(DamageEventHandler.class);
        forgeBus.register(DeathEventHandler.class);
        Network.registerMessages();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        ArtifactInit.buildNameLookup();
        event.enqueueWork(() -> PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_151079_, (Potion)((Potion)PotionsInit.GLOW_POTION.get())));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        ArtifactUnlockServer.getInstance().onServerStart();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ArtifactUnlockServer.getInstance().onServerStop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            IEventBus forgeEventbus = MinecraftForge.EVENT_BUS;
            forgeEventbus.addListener(ClientRenderEventHandler::onHighlightBlockEvent);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.CRYSTAL.get()), (RenderType)RenderType.m_110466_());
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            ItemPropertyFunction blockFunc = (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
            ItemPropertyFunction pullPercentFunc = (p174635, p174636, p174637, p174638) -> {
                if (p174637 == null) {
                    return 0.0f;
                }
                return p174637.m_21211_() != p174635 ? 0.0f : (float)(p174635.m_41779_() - p174637.m_21212_()) / 20.0f;
            };
            ItemPropertyFunction isPullingFunc = (p174630, p174631, p174632, p174633) -> p174632 != null && p174632.m_6117_() && p174632.m_21211_() == p174630 ? 1.0f : 0.0f;
            ItemProperties.register((Item)((Item)ArtifactInit.REFLECTING_SHIELD.get()), (ResourceLocation)new ResourceLocation("minecraft:blocking"), (ItemPropertyFunction)blockFunc);
            ItemProperties.register((Item)((Item)ArtifactInit.AMETHYST_SHIELD.get()), (ResourceLocation)new ResourceLocation("minecraft:blocking"), (ItemPropertyFunction)blockFunc);
            ItemProperties.register((Item)((Item)ArtifactInit.SONIC_BOW.get()), (ResourceLocation)new ResourceLocation("minecraft:pull"), (ItemPropertyFunction)pullPercentFunc);
            ItemProperties.register((Item)((Item)ArtifactInit.SONIC_BOW.get()), (ResourceLocation)new ResourceLocation("minecraft:pulling"), (ItemPropertyFunction)isPullingFunc);
        }

        @SubscribeEvent
        public static void onRenderRegistry(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.PEDESTAL.get(), ctx -> new PedestalRenderer());
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.LOCK_PEDESTAL.get(), ctx -> new LockPedestalRenderer());
            event.registerEntityRenderer((EntityType)EntityInit.AMETHYST_PROJECTILE.get(), AmethystProjectileRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.SONIC_BOOM_PROJECTILE.get(), SonicBoomProjectileRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.CRYSTAL_ARROW.get(), CrystalArrowRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterRenderLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(AmethystProjectileModel.LAYER_LOCATION, AmethystProjectileModel::createBodyLayer);
        }
    }
}

