/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class SuggestionEditBox
extends EditBox {
    private static final int TEXT_COLOR = 0xA0A0A0;
    private final SuggestionComponent<?> suggestions;

    public <T> SuggestionEditBox(Font font, int x, int y, int width, int height, Component name, int maxSuggestionLines, Collection<T> suggestions, Function<T, String> toString) {
        super(font, x, y, width, height, name);
        this.suggestions = new SuggestionComponent<T>(suggestions, toString, maxSuggestionLines);
        this.m_94151_(s -> {});
    }

    public SuggestionEditBox(Font font, int x, int y, int width, int height, Component name, int maxSuggestionLines, Collection<?> suggestions) {
        this(font, x, y, width, height, name, maxSuggestionLines, suggestions, Object::toString);
    }

    public void m_6305_(PoseStack posStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(posStack, mouseX, mouseY, partialTicks);
        if (this.m_93696_()) {
            this.suggestions.x = this.f_93620_ - 1;
            this.suggestions.y = this.f_93621_ + this.m_93694_() + 1;
            this.suggestions.m_6305_(posStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7207_(boolean flag) {
        super.m_7207_(flag);
        this.suggestions.update(this.m_94155_());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        boolean isOverText = super.m_5953_(mouseX, mouseY);
        if (this.m_93696_() && (isOverText || this.suggestions.m_5953_(mouseX, mouseY))) {
            return true;
        }
        return isOverText;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.suggestions.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        if (this.m_93696_() && this.suggestions.m_5953_(mouseX, mouseY)) {
            return this.suggestions.m_6375_(mouseX, mouseY, clickType);
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_7933_(int keyCode, int keyB, int modifiers) {
        if (keyCode == 256 && this.m_93696_()) {
            this.m_93692_(false);
            return true;
        }
        if (this.suggestions.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, keyB, modifiers);
    }

    public void m_94151_(Consumer<String> responder) {
        super.m_94151_(s -> {
            responder.accept((String)s);
            this.suggestions.update(this.m_94155_());
        });
    }

    public class SuggestionComponent<T>
    extends GuiComponent
    implements Widget,
    GuiEventListener {
        private final Minecraft mc = Minecraft.m_91087_();
        private final int maxLines;
        private final List<String> allOptions;
        private int x;
        private int y;
        private int height = 10;
        private int width = 10;
        private List<String> currentOptions = new ArrayList<String>();
        private int lineRenderStart = 0;
        private int selectedLine = 0;

        public SuggestionComponent(Collection<T> suggestions, Function<T, String> toString, int maxLines) {
            this.x = SuggestionEditBox.this.f_93620_ - 1;
            this.y = SuggestionEditBox.this.f_93621_ + SuggestionEditBox.this.m_93694_() + 1;
            this.allOptions = suggestions.stream().map(toString).collect(Collectors.toList());
            Collections.sort(this.allOptions, Collator.getInstance());
            this.maxLines = Math.min(this.allOptions.size(), maxLines);
            this.update("");
        }

        public void update(String input) {
            this.currentOptions.clear();
            if (input.isEmpty()) {
                this.currentOptions.addAll(this.allOptions);
            } else {
                this.allOptions.stream().filter(s -> s.startsWith(input) || s.contains(":") && s.substring(s.indexOf(":") + 1).startsWith(input)).forEach(this.currentOptions::add);
                this.allOptions.stream().filter(s -> !this.currentOptions.contains(s)).filter(s -> s.contains(input)).forEach(this.currentOptions::add);
            }
            int maxWidth = 0;
            for (String op : this.currentOptions) {
                int w = this.mc.f_91062_.m_92895_(op);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            this.width = maxWidth + 2;
            int lines = Math.min(this.maxLines, this.currentOptions.size());
            Objects.requireNonNull(this.mc.f_91062_);
            this.height = 9 * lines + lines * 2 + 4;
            this.selectedLine = 0;
            this.lineRenderStart = 0;
        }

        @Nullable
        public String getSelected() {
            if (this.selectedLine < this.currentOptions.size() && this.selectedLine > -1) {
                return this.currentOptions.get(this.selectedLine);
            }
            return null;
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            int size = this.currentOptions.size();
            if (size < 1) {
                return;
            }
            SuggestionEditBox editBox = SuggestionEditBox.this;
            if (this.maxLines > 0) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)Integer.MIN_VALUE);
                Font font = this.mc.f_91062_;
                for (int line = 0; line < this.maxLines; ++line) {
                    int renderLine = line + this.lineRenderStart;
                    if (renderLine >= size) continue;
                    Objects.requireNonNull(font);
                    SuggestionComponent.m_93236_((PoseStack)poseStack, (Font)font, (String)this.currentOptions.get(renderLine), (int)(this.x + 1), (int)(this.y + 4 + line * (9 + 2)), (int)(renderLine == this.selectedLine ? ChatFormatting.YELLOW.m_126665_() : 0xA0A0A0));
                }
                if (size > this.maxLines) {
                    int startX = this.x + this.width;
                    int h = 6;
                    int startY = this.y + (int)((double)this.selectedLine / (double)size * (double)(this.height - h));
                    Objects.requireNonNull(this.mc.f_91062_);
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)startX, (int)startY, (int)(startX + 2), (int)(startY + 9 + h), (int)Integer.MAX_VALUE);
                }
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, -10.0);
            SuggestionComponent.m_93236_((PoseStack)poseStack, (Font)this.mc.f_91062_, (String)this.getSelected(), (int)(this.x + 5), (int)(this.y - editBox.f_93619_ / 2 - 5), (int)0x505050);
            poseStack.m_85849_();
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            if (this.currentOptions.size() > 1) {
                int dir;
                int n = dir = amount < 0.0 ? -1 : 1;
                if (dir < 0) {
                    this.moveSelectorDown();
                } else if (dir > 0) {
                    this.moveSelectorUp();
                }
                return true;
            }
            return false;
        }

        public boolean m_7933_(int keyCode, int keyB, int modifiers) {
            if (keyCode == 258) {
                String selectedVal = this.getSelected();
                if (selectedVal != null && !SuggestionEditBox.this.m_94155_().equals(selectedVal)) {
                    SuggestionEditBox.this.m_94144_(selectedVal);
                    return true;
                }
            } else {
                if (keyCode == 264) {
                    this.moveSelectorDown();
                    return true;
                }
                if (keyCode == 265) {
                    this.moveSelectorUp();
                    return true;
                }
            }
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int clickType) {
            double d = mouseY - (double)this.y - 2.0;
            Objects.requireNonNull(this.mc.f_91062_);
            int clickedLine = (int)(d / (double)(9 + 2));
            this.selectedLine = Math.min(Math.max(0, clickedLine), this.maxLines - 1) + this.lineRenderStart;
            String selected = this.getSelected();
            if (selected != null) {
                SuggestionEditBox.this.m_94144_(selected);
                return true;
            }
            return false;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseX > (double)this.x && mouseX < (double)(this.x + this.width) && mouseY > (double)this.y && mouseY < (double)(this.y + this.height);
        }

        public void moveSelectorDown() {
            if (this.selectedLine < this.currentOptions.size() - 1) {
                ++this.selectedLine;
                if (this.selectedLine > this.lineRenderStart + this.maxLines - 1) {
                    ++this.lineRenderStart;
                }
            } else {
                this.selectedLine = 0;
                this.lineRenderStart = 0;
            }
        }

        public void moveSelectorUp() {
            if (this.selectedLine > 0) {
                --this.selectedLine;
                if (this.selectedLine < this.lineRenderStart) {
                    --this.lineRenderStart;
                }
            } else {
                this.selectedLine = this.currentOptions.size() - 1;
                if (this.selectedLine > this.lineRenderStart + this.maxLines - 1) {
                    this.lineRenderStart = this.currentOptions.size() - this.maxLines;
                }
            }
        }
    }
}

