/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.config;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ConfigBuilder {
    public static <T> ForgeConfigSpec.ConfigValue<T> makeConfig(ForgeConfigSpec.Builder builder, String name, String comment, T defaultVal) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).define(name, defaultVal);
    }

    public static <T> ForgeConfigSpec.ConfigValue<T> makeConfig(ForgeConfigSpec.Builder builder, String name, String comment, Object example, T defaultVal) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal, example)).define(name, defaultVal);
    }

    public static ForgeConfigSpec.BooleanValue makeBoolean(ForgeConfigSpec.Builder builder, String name, String comment, boolean defaultVal) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).define(name, defaultVal);
    }

    public static ForgeConfigSpec.IntValue makeInt(ForgeConfigSpec.Builder builder, String name, String comment, int defaultVal, int min, int max) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).defineInRange(name, defaultVal, min, max);
    }

    public static ForgeConfigSpec.LongValue makeLong(ForgeConfigSpec.Builder builder, String name, String comment, long defaultVal, long min, long max) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).defineInRange(name, defaultVal, min, max);
    }

    public static ForgeConfigSpec.DoubleValue makeDouble(ForgeConfigSpec.Builder builder, String name, String comment, double defaultVal, double min, double max) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).defineInRange(name, defaultVal, min, max);
    }

    public static <T extends Enum<T>> ForgeConfigSpec.EnumValue<T> makeEnum(ForgeConfigSpec.Builder builder, String name, String comment, T defaultVal) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).defineEnum(name, defaultVal);
    }

    public static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> makeList(ForgeConfigSpec.Builder builder, String name, String comment, List<T> defaultVal, Predicate<Object> validator) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).defineList(name, defaultVal, validator);
    }

    public static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> makeEmptyList(ForgeConfigSpec.Builder builder, String name, String comment, List<T> defaultVal, Predicate<Object> validator) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal)).defineListAllowEmpty(List.of(name), () -> defaultVal, validator);
    }

    public static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> makeList(ForgeConfigSpec.Builder builder, String name, String comment, Object example, List<T> defaultVal, Predicate<Object> validator) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal, example)).defineList(name, defaultVal, validator);
    }

    public static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> makeEmptyList(ForgeConfigSpec.Builder builder, String name, String comment, Object example, List<T> defaultVal, Predicate<Object> validator) {
        return builder.comment(ConfigBuilder.comment(comment, defaultVal, example)).defineListAllowEmpty(List.of(name), () -> defaultVal, validator);
    }

    public static String comment(String description, Object defaultVal, Object example) {
        return String.format("\n %s\n Example: %s\n Default: %s", description, ConfigBuilder.valString(example), ConfigBuilder.valString(defaultVal));
    }

    public static String comment(String description, Object defaultVal) {
        return String.format("\n %s\n Default: %s", description, ConfigBuilder.valString(defaultVal));
    }

    private static String valString(Object val) {
        if (val instanceof List) {
            List list = (List)val;
            if (list.isEmpty()) {
                return "[]";
            }
            return "[\"" + String.join((CharSequence)"\", \"", list.stream().map(Object::toString).collect(Collectors.toList())) + "\"]";
        }
        return val.toString();
    }
}

