/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.util;

import com.google.common.primitives.Ints;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import connor135246.simplyhotsprings.util.GenerationReason;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import connor135246.simplyhotsprings.util.TagKeyArgument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class SimplyHotSpringsCommand {
    public static final String COMMAND = "simplyhotsprings";
    public static final String HELP = "help";
    public static final String LOCATIONINFO = "locationinfo";
    public static final String BIOMESLIST = "biomeslist";
    public static final String ALL = "all";
    public static final String WITH = "with";
    public static final String WITHOUT = "without";
    public static final String BIOMETAGS = "biometags";
    public static final String LANG_COMMAND = "commands.simplyhotsprings.";
    public static final String LANG_LOCATIONINFO = "commands.simplyhotsprings.locationinfo.";
    public static final String LANG_BIOMESLIST = "commands.simplyhotsprings.biomeslist.";
    public static final String LANG_BIOMETAGS = "commands.simplyhotsprings.biometags.";
    public static final String LANG_HELP = "commands.simplyhotsprings.help.";
    public static final String NONE = "commands.simplyhotsprings.none";
    public static final String PLACE = "place";
    public static final SuggestionProvider<CommandSourceStack> ALL_MODIFIERS = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("simplyhotsprings", "all_modifiers"), (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)SimplyHotSpringsConfig.biomeModifierReasons.columnKeySet(), (SuggestionsBuilder)builder));
    private static final HoverEvent clickForSuggest = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.simplyhotsprings.locationinfo.click"));
    private static final HoverEvent clickForInfo = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.simplyhotsprings.biomeslist.click"));
    private static final HoverEvent clickForList = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.simplyhotsprings.biometags.click"));
    private static final HoverEvent clickForHelp = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.simplyhotsprings.help.click"));
    private static final HoverEvent clickForNext = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.simplyhotsprings.next_page"));
    private static final HoverEvent clickForPrevious = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.simplyhotsprings.previous_page"));
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID = new DynamicCommandExceptionType(args -> Component.m_237110_((String)"commands.simplyhotsprings.locationinfo.biome_not_found", (Object[])new Object[]{args}));
    private static final DynamicCommandExceptionType ERROR_BIOME_TAG_INVALID = new DynamicCommandExceptionType(args -> Component.m_237110_((String)"commands.simplyhotsprings.biometags.tag_not_found", (Object[])new Object[]{args}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND).requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)HELP).executes(context -> SimplyHotSpringsCommand.sendHelp((CommandSourceStack)context.getSource()))).then(Commands.m_82127_((String)LOCATIONINFO).executes(context -> SimplyHotSpringsCommand.sendHelpForSubcommand((CommandSourceStack)context.getSource(), LOCATIONINFO, 7)))).then(Commands.m_82127_((String)BIOMESLIST).executes(context -> SimplyHotSpringsCommand.sendHelpForSubcommand((CommandSourceStack)context.getSource(), BIOMESLIST, 5)))).then(Commands.m_82127_((String)BIOMETAGS).executes(context -> SimplyHotSpringsCommand.sendHelpForSubcommand((CommandSourceStack)context.getSource(), BIOMETAGS, 3)))).then(Commands.m_82127_((String)PLACE).executes(context -> SimplyHotSpringsCommand.sendHelpForSubcommand((CommandSourceStack)context.getSource(), PLACE, 1))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)LOCATIONINFO).executes(context -> SimplyHotSpringsCommand.sendLocationInfo((CommandSourceStack)context.getSource(), SimplyHotSpringsCommand.getSourcePos((CommandSourceStack)context.getSource())))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> SimplyHotSpringsCommand.sendLocationInfo((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target").m_20183_())))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> SimplyHotSpringsCommand.sendLocationInfo((CommandSourceStack)context.getSource(), BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"))))).then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registry.f_122885_)).executes(context -> SimplyHotSpringsCommand.sendLocationInfo((CommandSourceStack)context.getSource(), SimplyHotSpringsCommand.getResourceKey((CommandContext<CommandSourceStack>)context, "biome", Registry.f_122885_, ERROR_BIOME_INVALID)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)BIOMESLIST).then(SimplyHotSpringsCommand.withPageArg(Commands.m_82127_((String)ALL), (context, page) -> SimplyHotSpringsCommand.sendAllKnownBiomes((CommandSourceStack)context.getSource(), page)))).then(Commands.m_82127_((String)WITH).then(SimplyHotSpringsCommand.withPageArg(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ALL_MODIFIERS), (context, page) -> SimplyHotSpringsCommand.sendKnownBiomesForModifer((CommandSourceStack)context.getSource(), (ResourceLocation)context.getArgument("modifier", ResourceLocation.class), true, page))))).then(Commands.m_82127_((String)WITHOUT).then(SimplyHotSpringsCommand.withPageArg(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ALL_MODIFIERS), (context, page) -> SimplyHotSpringsCommand.sendKnownBiomesForModifer((CommandSourceStack)context.getSource(), (ResourceLocation)context.getArgument("modifier", ResourceLocation.class), false, page)))))).then(SimplyHotSpringsCommand.withPageArg(Commands.m_82127_((String)BIOMETAGS), (context, page) -> SimplyHotSpringsCommand.sendAllBiomeTags((CommandSourceStack)context.getSource(), page)).then(SimplyHotSpringsCommand.withPageArg(Commands.m_82129_((String)"biome_tag", TagKeyArgument.tagKeyArgument(Registry.f_122885_)), (context, page) -> SimplyHotSpringsCommand.sendBiomesOfTag((CommandSourceStack)context.getSource(), TagKeyArgument.get((CommandContext<CommandSourceStack>)context, "biome_tag", Registry.f_122885_, ERROR_BIOME_TAG_INVALID), page)))));
    }

    public static <T> ResourceKey<T> getResourceKey(CommandContext<CommandSourceStack> context, String name, ResourceKey<Registry<T>> registry, DynamicCommandExceptionType exception) throws CommandSyntaxException {
        ResourceKey result = (ResourceKey)context.getArgument(name, ResourceKey.class);
        Optional optional = result.m_195975_(registry);
        return (ResourceKey)optional.orElseThrow(() -> exception.create((Object)result.m_135782_()));
    }

    private static BlockPos getSourcePos(CommandSourceStack source) throws CommandSyntaxException {
        BlockPos pos = new BlockPos(source.m_81371_());
        if (!source.getUnsidedLevel().m_46805_(pos)) {
            throw BlockPosArgument.f_118234_.create();
        }
        if (!source.getUnsidedLevel().m_46739_(pos)) {
            throw BlockPosArgument.f_118235_.create();
        }
        return pos;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> withPageArg(ArgumentBuilder<CommandSourceStack, ?> argument, CommandContextIntFunction command) {
        return argument.executes(context -> command.applyAsInt((CommandContext<CommandSourceStack>)context, 0)).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> command.applyAsInt((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"page") - 1)));
    }

    private static int sendHelp(CommandSourceStack source) {
        source.m_81354_((Component)Component.m_237113_((String)"--- /simplyhotsprings help ---").m_130940_(ChatFormatting.GOLD), false);
        source.m_81354_((Component)SimplyHotSpringsCommand.makeHelpComponent(LOCATIONINFO), false);
        source.m_81354_((Component)SimplyHotSpringsCommand.makeHelpComponent(BIOMESLIST), false);
        source.m_81354_((Component)SimplyHotSpringsCommand.makeHelpComponent(BIOMETAGS), false);
        source.m_81354_((Component)Component.m_237113_((String)"/place feature simplyhotsprings:hot_springs_default").m_6270_(Style.f_131099_.m_131144_(clickForHelp).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/simplyhotsprings help place"))), false);
        return 4;
    }

    private static int sendHelpForSubcommand(CommandSourceStack source, String subcommand, int helps) {
        source.m_81354_((Component)Component.m_237113_((String)("--- /simplyhotsprings help " + subcommand + " ---")).m_130940_(ChatFormatting.GOLD), false);
        for (int i = 0; i <= helps; ++i) {
            source.m_81354_((Component)Component.m_237115_((String)(LANG_HELP + subcommand + "." + i)).m_130940_(i % 2 == 1 ? ChatFormatting.GRAY : ChatFormatting.WHITE), false);
        }
        return helps + 1;
    }

    private static int sendLocationInfo(CommandSourceStack source, BlockPos pos) {
        return SimplyHotSpringsCommand.sendLocationInfo(source, (Holder<Biome>)source.m_81372_().m_204166_(pos));
    }

    private static int sendLocationInfo(CommandSourceStack source, ResourceKey<Biome> biomeKey) throws CommandSyntaxException {
        Registry biomeReg = source.m_5894_().m_175515_(Registry.f_122885_);
        return SimplyHotSpringsCommand.sendLocationInfo(source, (Holder<Biome>)((Holder)biomeReg.m_203636_(biomeKey).orElseThrow(() -> ERROR_BIOME_INVALID.create((Object)biomeKey))));
    }

    private static int sendLocationInfo(CommandSourceStack source, Holder<Biome> biome) {
        source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.locationinfo.biome_name", new Object[0]).m_7220_((Component)SimplyHotSpringsCommand.makeSuggestComponent(source.m_5894_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)biome.m_203334_())).toString())), false);
        List tags = biome.getTagKeys().collect(Collectors.toList());
        if (tags.isEmpty()) {
            source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.locationinfo.biome_tags", new Object[0]).m_7220_((Component)SimplyHotSpringsCommand.noneComponent().m_130940_(ChatFormatting.WHITE)), false);
        } else {
            source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.locationinfo.biome_tags", new Object[0]).m_7220_(SimplyHotSpringsCommand.makeMultiComponent(tags, SimplyHotSpringsCommand.sortTag(), tag -> SimplyHotSpringsCommand.makeSuggestComponent("#" + tag.f_203868_()))), false);
        }
        if (SimplyHotSpringsConfig.biomeModifierReasons.isEmpty()) {
            source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.locationinfo.hot_springs", new Object[0]).m_7220_((Component)SimplyHotSpringsCommand.noneHotSpringsReasonComponent(GenerationReason.NO_HOT_SPRINGS)), false);
            return 0;
        }
        Map map = SimplyHotSpringsConfig.biomeModifierReasons.row(biome);
        if (map.isEmpty()) {
            source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.locationinfo.hot_springs", new Object[0]).m_7220_((Component)SimplyHotSpringsCommand.noneHotSpringsReasonComponent(GenerationReason.UNKNOWN_BIOME)), false);
        } else {
            source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.locationinfo.hot_springs", new Object[0]).m_7220_(SimplyHotSpringsCommand.makeMultiComponent(map.keySet(), ResourceLocation::compareNamespaced, id -> SimplyHotSpringsCommand.textHotSpringsReasonComponent(id.toString(), map.containsKey(id) ? (GenerationReason)((Object)((Object)map.get(id))) : GenerationReason.UNKNOWN_MODIFIER))), false);
        }
        return Ints.saturatedCast((long)map.values().stream().filter(reason -> reason.allowsGeneration()).count());
    }

    private static int sendAllKnownBiomes(CommandSourceStack source, int page) {
        if (SimplyHotSpringsConfig.biomeModifierReasons.rowKeySet().isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)GenerationReason.NO_HOT_SPRINGS.getKey()));
            return 0;
        }
        source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.biomeslist.all", new Object[0]), false);
        Set biomes = SimplyHotSpringsConfig.biomeModifierReasons.rowKeySet().stream().map(biome -> ((ResourceKey)biome.m_203543_().get()).m_135782_()).collect(Collectors.toSet());
        SimplyHotSpringsCommand.sendPaginatedComponents(source, biomes, ResourceLocation::compareNamespaced, id -> SimplyHotSpringsCommand.makeLocationInfoComponent(id.toString()), page, "/simplyhotsprings biomeslist all");
        return biomes.size();
    }

    private static int sendKnownBiomesForModifer(CommandSourceStack source, ResourceLocation modifier, boolean with, int page) throws CommandSyntaxException {
        if (!SimplyHotSpringsConfig.biomeModifierReasons.columnKeySet().contains(modifier)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.simplyhotsprings.biomeslist.modifier_not_found", (Object[])new Object[]{modifier}));
            return 0;
        }
        source.m_81354_((Component)Component.m_237110_((String)(LANG_BIOMESLIST + (with ? WITH : WITHOUT)), (Object[])new Object[]{modifier}).m_130940_(with ? ChatFormatting.GREEN : ChatFormatting.DARK_RED), false);
        Set filteredIds = SimplyHotSpringsConfig.biomeModifierReasons.column((Object)modifier).entrySet().stream().filter(entry -> with == ((GenerationReason)((Object)((Object)entry.getValue()))).allowsGeneration()).map(entry -> ((ResourceKey)((Holder)entry.getKey()).m_203543_().get()).m_135782_()).collect(Collectors.toSet());
        SimplyHotSpringsCommand.sendPaginatedComponents(source, filteredIds, ResourceLocation::compareNamespaced, id -> SimplyHotSpringsCommand.makeLocationInfoComponent(id.toString()), page, "/simplyhotsprings biomeslist " + (with ? WITH : WITHOUT) + " " + modifier);
        return filteredIds.size();
    }

    private static int sendAllBiomeTags(CommandSourceStack source, int page) {
        source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.biometags.all", new Object[0]), false);
        List tags = source.m_5894_().m_175515_(Registry.f_122885_).m_203613_().collect(Collectors.toList());
        SimplyHotSpringsCommand.sendPaginatedComponents(source, tags, SimplyHotSpringsCommand.sortTag(), tag -> SimplyHotSpringsCommand.makeBiomeTagComponent("#" + tag.f_203868_()), page, "/simplyhotsprings biometags");
        return tags.size();
    }

    private static int sendBiomesOfTag(CommandSourceStack source, TagKey<Biome> tagKey, int page) throws CommandSyntaxException {
        source.m_81354_((Component)SimplyHotSpringsCommand.makeAquaTranslatable("commands.simplyhotsprings.biometags.biomes", "#" + tagKey.f_203868_()), false);
        Set biomes = ((HolderSet.Named)source.m_5894_().m_175515_(Registry.f_122885_).m_203431_(tagKey).orElseThrow(() -> ERROR_BIOME_TAG_INVALID.create((Object)("#" + tagKey.f_203868_())))).m_203614_().map(biome -> ((ResourceKey)biome.m_203543_().get()).m_135782_()).collect(Collectors.toSet());
        SimplyHotSpringsCommand.sendPaginatedComponents(source, biomes, ResourceLocation::compareNamespaced, id -> SimplyHotSpringsCommand.makeLocationInfoComponent(id.toString()), page, "/simplyhotsprings biometags #" + tagKey.f_203868_());
        return biomes.size();
    }

    private static MutableComponent makeAquaTranslatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args).m_130940_(ChatFormatting.AQUA);
    }

    private static MutableComponent makeHotSpringsReasonComponent(MutableComponent component, GenerationReason reason) {
        return component.m_6270_(Style.f_131099_.m_131157_(reason.getTextFormatting()).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)reason.getYN()).m_130940_(reason.getTextFormatting()).m_130946_(": \n").m_7220_((Component)Component.m_237115_((String)reason.getKey()).m_130940_(reason.getTextFormatting())))));
    }

    private static MutableComponent textHotSpringsReasonComponent(String name, GenerationReason reason) {
        return SimplyHotSpringsCommand.makeHotSpringsReasonComponent(Component.m_237113_((String)name), reason);
    }

    private static MutableComponent noneHotSpringsReasonComponent(GenerationReason reason) {
        return SimplyHotSpringsCommand.makeHotSpringsReasonComponent(SimplyHotSpringsCommand.noneComponent(), reason);
    }

    private static MutableComponent makeSuggestComponent(String toCopy) {
        return Component.m_237113_((String)toCopy).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.WHITE).m_131144_(clickForSuggest).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, toCopy)));
    }

    private static MutableComponent makeLocationInfoComponent(String location) {
        return Component.m_237113_((String)location).m_6270_(Style.f_131099_.m_131144_(clickForInfo).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/simplyhotsprings locationinfo " + location)));
    }

    private static MutableComponent makeBiomeTagComponent(String name) {
        return Component.m_237113_((String)name).m_6270_(Style.f_131099_.m_131144_(clickForList).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/simplyhotsprings biometags " + name)));
    }

    private static MutableComponent makeHelpComponent(String subcommand) {
        String command = "/simplyhotsprings help " + subcommand;
        return Component.m_237113_((String)command).m_6270_(Style.f_131099_.m_131144_(clickForHelp).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)));
    }

    private static MutableComponent makePageComponent(int current, int max, String pageCommand) {
        return Component.m_237110_((String)"commands.simplyhotsprings.page_header", (Object[])new Object[]{Component.m_237113_((String)"<--").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY).m_131144_(clickForPrevious).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pageCommand + " " + Math.max(1, current - 1 < 1 ? max : current - 1)))), Component.m_237113_((String)"-->").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY).m_131144_(clickForNext).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pageCommand + " " + (current + 1 > max ? 1 : current + 1)))), current, max}).m_130940_(ChatFormatting.GRAY);
    }

    private static MutableComponent noneComponent() {
        return Component.m_237115_((String)NONE);
    }

    private static <T> void sendPaginatedComponents(CommandSourceStack source, Collection<T> collection, @Nullable Comparator<T> comparator, Function<T, Component> toTextComponent, int page, String pageCommand) {
        int itemsPerPage = 8;
        int maxPage = collection.size() / itemsPerPage + (collection.size() % itemsPerPage == 0 ? 0 : 1) - 1;
        if (page > maxPage) {
            page = maxPage;
        }
        source.m_81354_((Component)SimplyHotSpringsCommand.makePageComponent(page + 1, maxPage + 1, pageCommand), false);
        if (collection.isEmpty()) {
            source.m_81354_((Component)Component.m_237113_((String)" ").m_7220_((Component)SimplyHotSpringsCommand.noneComponent()), false);
        } else {
            ArrayList<T> list = new ArrayList<T>(collection);
            list.sort(comparator);
            for (int i = page * itemsPerPage; i < list.size() && i < (page + 1) * itemsPerPage; ++i) {
                source.m_81354_((Component)Component.m_237113_((String)" ").m_7220_(toTextComponent.apply(list.get(i))), false);
            }
        }
    }

    private static <T> Component makeMultiComponent(Collection<T> collection, @Nullable Comparator<T> comparator, Function<T, Component> toTextComponent) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return ComponentUtils.m_178440_(list, toTextComponent);
    }

    private static Comparator<TagKey<Biome>> sortTag() {
        return (tag1, tag2) -> tag1.f_203868_().compareNamespaced(tag2.f_203868_());
    }

    @FunctionalInterface
    private static interface CommandContextIntFunction {
        public int applyAsInt(CommandContext<CommandSourceStack> var1, int var2) throws CommandSyntaxException;
    }
}

