/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common.world.gen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class CeilingAwareHeightmapPlacement
extends PlacementModifier {
    public static final Codec<CeilingAwareHeightmapPlacement> CODEC = RecordCodecBuilder.create(p_191701_ -> p_191701_.group((App)Heightmap.Types.f_64274_.fieldOf("heightmap").forGetter(p_191705_ -> p_191705_.heightmap), (App)VerticalAnchor.f_158914_.optionalFieldOf("min_height", (Object)VerticalAnchor.m_158921_()).forGetter(p_191705_ -> p_191705_.minHeight), (App)IntProvider.f_146531_.fieldOf("roof_offset").forGetter(p_191705_ -> p_191705_.roofOffset), (App)VerticalAnchor.f_158914_.optionalFieldOf("max_height_if_below_roof", (Object)VerticalAnchor.m_158929_()).forGetter(p_191705_ -> p_191705_.maxHeightIfBelowRoof)).apply((Applicative)p_191701_, CeilingAwareHeightmapPlacement::new));
    private final Heightmap.Types heightmap;
    private final VerticalAnchor minHeight;
    private final IntProvider roofOffset;
    private final VerticalAnchor maxHeightIfBelowRoof;
    private static final CeilingAwareHeightmapPlacement simpleSurface = new CeilingAwareHeightmapPlacement(Heightmap.Types.WORLD_SURFACE_WG, VerticalAnchor.m_158921_(), (IntProvider)ConstantInt.m_146483_((int)16), VerticalAnchor.m_158929_());
    public static final PlacementModifierType<CeilingAwareHeightmapPlacement> TYPE = new PlacementModifierType<CeilingAwareHeightmapPlacement>(){

        public Codec<CeilingAwareHeightmapPlacement> m_191869_() {
            return CODEC;
        }
    };

    public CeilingAwareHeightmapPlacement(Heightmap.Types heightmap, VerticalAnchor minHeight, IntProvider roofOffset, VerticalAnchor maxHeightIfBelowRoof) {
        this.heightmap = heightmap;
        this.minHeight = minHeight;
        this.roofOffset = roofOffset;
        this.maxHeightIfBelowRoof = maxHeightIfBelowRoof;
    }

    public static CeilingAwareHeightmapPlacement simpleSurface() {
        return simpleSurface;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource rand, BlockPos pos) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int y = context.m_191824_(this.heightmap, x, z);
        pos = new BlockPos(x, y, z);
        if (context.m_191831_().m_6042_().f_63856_() && context.m_191831_().m_7433_(pos.m_7495_(), state -> state.m_60713_(Blocks.f_50752_))) {
            int maximum = this.maxHeightIfBelowRoof.m_142322_((WorldGenerationContext)context);
            if (pos.m_123342_() > maximum) {
                pos = new BlockPos(pos.m_123341_(), maximum, pos.m_123343_());
            }
            pos = pos.m_6625_(this.roofOffset.m_214085_(rand));
            while (pos.m_123342_() >= context.m_142201_() && !context.m_191831_().m_46859_(pos)) {
                pos = pos.m_7495_();
            }
            while (pos.m_123342_() >= context.m_142201_() && context.m_191831_().m_46859_(pos)) {
                pos = pos.m_7495_();
            }
            pos = pos.m_7494_();
        }
        return pos.m_123342_() > this.minHeight.m_142322_((WorldGenerationContext)context) ? Stream.of(pos) : Stream.of(new BlockPos[0]);
    }

    public PlacementModifierType<?> m_183327_() {
        return TYPE;
    }
}

