/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import connor135246.simplyhotsprings.SimplyHotSprings;
import connor135246.simplyhotsprings.util.GenerationReason;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public record AddHotSpringsBiomeModifier(HolderSet<PlacedFeature> hotSprings, HolderSet<Biome> biomes, boolean isBlacklist, GenerationStep.Decoration step) implements BiomeModifier
{
    public static final Codec<AddHotSpringsBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)PlacedFeature.f_191774_.fieldOf("hot_springs").forGetter(AddHotSpringsBiomeModifier::hotSprings), (App)Biome.f_47432_.fieldOf("biomes").forGetter(AddHotSpringsBiomeModifier::biomes), (App)Codec.BOOL.fieldOf("is_blacklist").forGetter(AddHotSpringsBiomeModifier::isBlacklist), (App)GenerationStep.Decoration.f_224188_.optionalFieldOf("step", (Object)GenerationStep.Decoration.LAKES).forGetter(AddHotSpringsBiomeModifier::step)).apply((Applicative)builder, AddHotSpringsBiomeModifier::new));
    public static final ResourceLocation HOT_SPRINGS_DEFAULT = new ResourceLocation("simplyhotsprings", "hot_springs_default");
    public static final ResourceLocation HOT_SPRINGS_BIG = new ResourceLocation("simplyhotsprings", "hot_springs_big");
    public static final ResourceLocation HOT_SPRINGS_WELLSPRINGS = new ResourceLocation("simplyhotsprings", "hot_springs_wellsprings");
    public static final Set<AddHotSpringsBiomeModifier> warned = new HashSet<AddHotSpringsBiomeModifier>();

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            ResourceLocation id;
            try {
                id = ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(ForgeRegistries.Keys.BIOME_MODIFIERS).m_7981_((Object)this);
                if (id == null) {
                    throw new IllegalStateException("Null biome modifier id!");
                }
            }
            catch (IllegalStateException excep) {
                if (!warned.contains(this)) {
                    SimplyHotSprings.log.error("An error occurred when preparing a Hot Springs biome modifier with hot_springs: " + this.hotSprings + ", biome_list: " + this.biomes + ", is_blacklist: " + this.isBlacklist + " and step: " + this.step, (Throwable)excep);
                    warned.add(this);
                }
                return;
            }
            if (this.hotSprings.m_203632_() < 1) {
                if (!warned.contains(this)) {
                    SimplyHotSprings.log.warn("Ignoring Hot Springs biome modifier \"" + id + "\" with empty feature list!");
                    warned.add(this);
                }
                return;
            }
            if ((Boolean)SimplyHotSpringsConfig.SERVER.worldGenDefault.get() == false && HOT_SPRINGS_DEFAULT.equals((Object)id) || (Boolean)SimplyHotSpringsConfig.SERVER.worldGenBig.get() == false && HOT_SPRINGS_BIG.equals((Object)id) || !((Boolean)SimplyHotSpringsConfig.SERVER.worldGenWellsprings.get()).booleanValue() && HOT_SPRINGS_WELLSPRINGS.equals((Object)id)) {
                GenerationReason reason = GenerationReason.NO_WORLD_GEN_CONFIG;
                return;
            }
            GenerationReason reason = this.getGenerationReason(biome);
            SimplyHotSpringsConfig.biomeModifierReasons.put(biome, (Object)id, (Object)reason);
            if (reason.allowsGeneration()) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                this.hotSprings.forEach(holder -> generationSettings.m_204201_(this.step, holder));
            }
        }
    }

    public GenerationReason getGenerationReason(Holder<Biome> biome) {
        if (this.biomes.m_203333_(biome)) {
            return this.isBlacklist ? GenerationReason.BLACKLISTED : GenerationReason.WHITELISTED;
        }
        return this.isBlacklist ? GenerationReason.NOT_BLACKLISTED : GenerationReason.NOT_WHITELISTED;
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

