/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common.fluids;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class HotSpringWaterFluidType
extends FluidType {
    public HotSpringWaterFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canDrown(true).canSwim(true).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER_BORDER).canExtinguish(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).canHydrate(true).temperature(325));
    }

    public boolean canConvertToSource(FluidStack stack) {
        return (Boolean)SimplyHotSpringsConfig.SERVER.createsSources.get();
    }

    public boolean canConvertToSource(FluidState state, LevelReader reader, BlockPos pos) {
        return (Boolean)SimplyHotSpringsConfig.SERVER.createsSources.get();
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
            private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("simplyhotsprings", "block/still_hot_springs");
            private static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("simplyhotsprings", "block/flowing_hot_springs");
            private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getOverlayTexture() {
                return WATER_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(fluidFogColor.m_122239_() * 0.01f, fluidFogColor.m_122269_(), fluidFogColor.m_122269_());
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                float fogStart = -8.0f;
                float fogEnd = 96.0f;
                if (camera.m_90592_() instanceof LocalPlayer) {
                    fogEnd = (float)((double)fogEnd * 0.7875);
                }
                if (fogEnd > renderDistance) {
                    fogEnd = renderDistance;
                    RenderSystem.m_202160_((FogShape)FogShape.CYLINDER);
                }
                RenderSystem.m_157445_((float)fogStart);
                RenderSystem.m_157443_((float)fogEnd);
            }
        });
    }
}

