/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.Codec;
import connor135246.simplyhotsprings.common.blocks.HotSpringWaterBlock;
import connor135246.simplyhotsprings.common.fluids.HotSpringWaterFluid;
import connor135246.simplyhotsprings.common.fluids.HotSpringWaterFluidType;
import connor135246.simplyhotsprings.common.world.gen.AddHotSpringsBiomeModifier;
import connor135246.simplyhotsprings.common.world.gen.feature.HotSpringsConfiguration;
import connor135246.simplyhotsprings.common.world.gen.feature.HotSpringsFeature;
import connor135246.simplyhotsprings.common.world.gen.placement.CeilingAwareHeightmapPlacement;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import connor135246.simplyhotsprings.util.TagKeyArgument;
import java.util.function.Supplier;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="simplyhotsprings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplyHotSpringsCommon {
    public static final String NAME = "hot_spring_water";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registry.f_122901_, (String)"simplyhotsprings");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registry.f_122904_, (String)"simplyhotsprings");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"simplyhotsprings");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registry.f_122899_, (String)"simplyhotsprings");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((ResourceKey)Registry.f_122906_, (String)"simplyhotsprings");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122838_, (String)"simplyhotsprings");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registry.f_194569_, (String)"simplyhotsprings");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"simplyhotsprings");
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registry.f_235724_, (String)"simplyhotsprings");
    public static final RegistryObject<FluidType> HOT_SPRING_WATER_FLUID_TYPE = FLUID_TYPES.register("hot_spring_water", HotSpringWaterFluidType::new);
    public static final RegistryObject<FlowingFluid> HOT_SPRING_WATER = FLUIDS.register("hot_spring_water", HotSpringWaterFluid.Source::new);
    public static final RegistryObject<FlowingFluid> FLOWING_HOT_SPRING_WATER = FLUIDS.register("flowing_hot_spring_water", HotSpringWaterFluid.Flowing::new);
    public static final RegistryObject<LiquidBlock> HOT_SPRING_WATER_BLOCK = BLOCKS.register("hot_spring_water", HotSpringWaterBlock::new);
    public static final RegistryObject<Item> HOT_SPRING_WATER_BUCKET = ITEMS.register("hot_spring_water_bucket", () -> new BucketItem(HOT_SPRING_WATER, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_).m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<SimpleParticleType> HOT_SPRING_WATER_STEAM = PARTICLES.register("hot_spring_water_steam", SimplyHotSpringsCommon.particleSimple(true));
    public static final RegistryObject<SimpleParticleType> HOT_SPRING_WATER_STEAM_SMALL = PARTICLES.register("hot_spring_water_steam_small", SimplyHotSpringsCommon.particleSimple(true));
    public static final RegistryObject<SimpleParticleType> DRIPPING_HOT_SPRING_WATER = PARTICLES.register("dripping_hot_spring_water", SimplyHotSpringsCommon.particleSimple(false));
    public static final RegistryObject<SimpleParticleType> FALLING_HOT_SPRING_WATER = PARTICLES.register("falling_hot_spring_water", SimplyHotSpringsCommon.particleSimple(false));
    public static final RegistryObject<SimpleParticleType> SPLASHING_HOT_SPRING_WATER = PARTICLES.register("splashing_hot_spring_water", SimplyHotSpringsCommon.particleSimple(false));
    public static final RegistryObject<SimpleParticleType> HOT_SPRING_WATER_UNDERWATER = PARTICLES.register("hot_spring_water_underwater", SimplyHotSpringsCommon.particleSimple(false));
    public static final RegistryObject<Feature<HotSpringsConfiguration>> HOT_SPRINGS_FEATURE = FEATURES.register("hot_springs", () -> new HotSpringsFeature(HotSpringsConfiguration.CODEC));
    public static final RegistryObject<PlacementModifierType<?>> CEILING_AWARE_HEIGHTMAP_PLACEMENT = PLACEMENT_MODIFIERS.register("ceiling_aware_heightmap", () -> CeilingAwareHeightmapPlacement.TYPE);
    public static final RegistryObject<Codec<AddHotSpringsBiomeModifier>> ADD_HOT_SPRINGS = BIOME_MODIFIER_SERIALIZERS.register("add_hot_springs", () -> AddHotSpringsBiomeModifier.CODEC);
    public static final RegistryObject<TagKeyArgument.Info<Object>> TAG_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register("tag", () -> (TagKeyArgument.Info)ArgumentTypeInfos.registerByClass(SimplyHotSpringsCommon.fixClassType(TagKeyArgument.class), new TagKeyArgument.Info()));
    public static final TagKey<Fluid> TAG_HOT_SPRING_WATER = FluidTags.create((ResourceLocation)new ResourceLocation("simplyhotsprings", "hot_spring_water"));
    public static final DispenseItemBehavior dispenseHotSpringWaterBehaviour = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)stack.m_41720_();
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            if (dispensiblecontaineritem.m_142073_((Player)null, (Level)level, blockpos, (BlockHitResult)null)) {
                dispensiblecontaineritem.m_142131_((Player)null, (Level)level, stack, blockpos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return this.defaultBehaviour.m_6115_(source, stack);
        }
    };

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
        FLUIDS.register(eventBus);
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        PARTICLES.register(eventBus);
        FEATURES.register(eventBus);
        PLACEMENT_MODIFIERS.register(eventBus);
        BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        COMMAND_ARGUMENT_TYPES.register(eventBus);
        eventBus.register(SimplyHotSpringsConfig.class);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HOT_SPRING_WATER_BUCKET.ifPresent(bucket -> DispenserBlock.m_52672_((ItemLike)bucket, (DispenseItemBehavior)dispenseHotSpringWaterBehaviour));
            HOT_SPRING_WATER_FLUID_TYPE.ifPresent(type -> FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(type, fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : Blocks.f_50652_.m_49966_())));
        });
    }

    private static Supplier<SimpleParticleType> particleSimple(boolean alwaysShow) {
        return () -> new SimpleParticleType(alwaysShow);
    }

    private static <T extends ArgumentType<?>> Class<T> fixClassType(Class<? super T> clazz) {
        return clazz;
    }
}

