/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mvs.world.structures;

import com.finndog.mvs.modinit.MVSStructures;
import com.finndog.mvs.utils.GeneralUtils;
import com.finndog.mvs.world.structures.pieces.PieceLimitedJigsawManager;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class GenericJigsawStructure
extends Structure {
    public static final Codec<GenericJigsawStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GenericJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.f_135803_.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StringRepresentable.m_216439_(BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack)).apply((Applicative)instance, GenericJigsawStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    public final int size;
    public final Optional<Integer> minYAllowed;
    public final Optional<Integer> maxYAllowed;
    public final Optional<Integer> allowedYRangeFromStart;
    public final HeightProvider startHeight;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final boolean cannotSpawnInLiquid;
    public final Optional<Integer> terrainHeightCheckRadius;
    public final Optional<Integer> allowedTerrainHeightRange;
    public final Optional<Integer> biomeRadius;
    public final HashSet<ResourceLocation> poolsThatIgnoreBoundaries;
    public final Optional<Integer> maxDistanceFromCenter;
    public final Optional<BURYING_TYPE> buryingType;
    public final boolean useBoundingBoxHack;

    public GenericJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<BURYING_TYPE> buryingType, boolean useBoundingBoxHack) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.minYAllowed = minYAllowed;
        this.maxYAllowed = maxYAllowed;
        this.allowedYRangeFromStart = allowedYRangeFromStart;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.cannotSpawnInLiquid = cannotSpawnInLiquid;
        this.terrainHeightCheckRadius = terrainHeightCheckRadius;
        this.allowedTerrainHeightRange = allowedTerrainHeightRange;
        this.biomeRadius = biomeRadius;
        this.poolsThatIgnoreBoundaries = poolsThatIgnoreBoundaries;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.buryingType = buryingType;
        this.useBoundingBoxHack = useBoundingBoxHack;
        if (maxYAllowed.isPresent() && minYAllowed.isPresent() && maxYAllowed.get() < minYAllowed.get()) {
            throw new RuntimeException("    Moog's Voyager Structures: maxYAllowed cannot be less than minYAllowed.\n    Please correct this error as there's no way to spawn this structure properly\n        Structure pool of problematic structure: %s\n".formatted(startPool.m_203334_()));
        }
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.f_226628_();
        if (this.biomeRadius.isPresent() && !(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            int sectionY = blockPos.m_123342_();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.f_226622_().m_223235_(blockPos.m_123341_(), blockPos.m_123343_(), this.projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
            }
            sectionY = QuartPos.m_175400_((int)sectionY);
            for (int curChunkX = chunkPos.f_45578_ - validBiomeRange; curChunkX <= chunkPos.f_45578_ + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - validBiomeRange; curChunkZ <= chunkPos.f_45579_ + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), sectionY, QuartPos.m_175404_((int)curChunkZ), context.f_226624_().m_224579_());
                    if (context.f_226630_().test(biome)) continue;
                    return false;
                }
            }
        }
        if (this.cannotSpawnInLiquid) {
            BlockPos centerOfChunk = chunkPos.m_151394_(0);
            int landHeight = context.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_226629_(), context.f_226624_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.f_45578_ - terrainCheckRange; curChunkX <= chunkPos.f_45578_ + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - terrainCheckRange; curChunkZ <= chunkPos.f_45579_ + terrainCheckRange; ++curChunkZ) {
                    int height = context.f_226622_().m_214096_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG), context.f_226629_(), context.f_226624_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.minYAllowed.isPresent() && minTerrainHeight < this.minYAllowed.get()) {
                        return false;
                    }
                    if (!this.maxYAllowed.isPresent() || minTerrainHeight <= this.maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int offsetY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), offsetY, context.f_226628_().m_45605_());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.allowedYRangeFromStart.isPresent()) {
            topClipOff = blockpos.m_123342_() + this.allowedYRangeFromStart.get();
            bottomClipOff = blockpos.m_123342_() - this.allowedYRangeFromStart.get();
        }
        if (this.maxYAllowed.isPresent()) {
            topClipOff = Math.min(topClipOff, this.maxYAllowed.get());
        }
        if (this.minYAllowed.isPresent()) {
            bottomClipOff = Math.max(bottomClipOff, this.minYAllowed.get());
        }
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.f_226621_().m_175515_(Registry.f_235725_).m_7981_((Object)this), blockpos, this.useBoundingBoxHack, this.projectStartToHeightmap, topClipOff, bottomClipOff, this.poolsThatIgnoreBoundaries, this.maxDistanceFromCenter, this.buryingType, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((StructurePiecesBuilder)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<PoolElementStructurePiece>)pieces));
    }

    protected void postLayoutAdjustments(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, int offsetY, BlockPos blockpos, int topClipOff, int bottomClipOff, List<PoolElementStructurePiece> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        if (this.buryingType.isEmpty()) {
            return;
        }
        if (this.buryingType.get() == BURYING_TYPE.LOWEST_CORNER) {
            Heightmap.Types heightMapToUse = this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG);
            BoundingBox box = pieces.get(0).m_73547_();
            int highestLandPos = context.f_226622_().m_223235_(box.m_162395_(), box.m_162398_(), heightMapToUse, context.f_226629_(), context.f_226624_());
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(box.m_162395_(), box.m_162401_(), heightMapToUse, context.f_226629_(), context.f_226624_()));
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(box.m_162399_(), box.m_162398_(), heightMapToUse, context.f_226629_(), context.f_226624_()));
            highestLandPos = Math.min(highestLandPos, context.f_226622_().m_223235_(box.m_162399_(), box.m_162401_(), heightMapToUse, context.f_226629_(), context.f_226624_()));
            if (!(this.cannotSpawnInLiquid || heightMapToUse != Heightmap.Types.OCEAN_FLOOR_WG && heightMapToUse != Heightmap.Types.OCEAN_FLOOR)) {
                int maxHeightForSubmerging = context.f_226622_().m_6337_() - box.m_71057_();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            } else {
                highestLandPos = Math.max(highestLandPos, context.f_226622_().m_6337_());
            }
            this.offsetToNewHeight(context, offsetY, pieces, box, highestLandPos);
        } else if (this.buryingType.get() == BURYING_TYPE.AVERAGE_LAND) {
            BoundingBox box = pieces.get(0).m_73547_();
            BlockPos centerPos = new BlockPos((Vec3i)box.m_162394_());
            int radius = (int)Math.sqrt(box.m_71053_().m_123341_() * box.m_71053_().m_123341_() + box.m_71053_().m_123343_() * box.m_71053_().m_123343_()) / 2;
            Heightmap.Types heightMapToUse = this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG);
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.f_226622_().m_223235_(centerPos.m_123341_() + xOffset, centerPos.m_123343_() + zOffset, heightMapToUse, context.f_226629_(), context.f_226624_());
                    landHeights.add(landHeight);
                }
            }
            OptionalDouble avgHeightOptional = landHeights.stream().filter(height -> height > this.minYAllowed.orElse(Integer.MIN_VALUE) && height < this.maxYAllowed.orElse(Integer.MAX_VALUE)).mapToInt(Integer::intValue).average();
            if (this.maxYAllowed.isPresent() && avgHeightOptional.isEmpty()) {
                avgHeightOptional = OptionalDouble.of(this.maxYAllowed.get().intValue());
            }
            if (this.minYAllowed.isPresent() && avgHeightOptional.isEmpty()) {
                avgHeightOptional = OptionalDouble.of(this.minYAllowed.get().intValue());
            }
            if (avgHeightOptional.isPresent()) {
                double avgHeight = avgHeightOptional.getAsDouble();
                if (this.cannotSpawnInLiquid && heightMapToUse != Heightmap.Types.OCEAN_FLOOR_WG && heightMapToUse != Heightmap.Types.OCEAN_FLOOR) {
                    avgHeight = Math.max(avgHeight, (double)context.f_226622_().m_6337_());
                    if (this.maxYAllowed.isPresent()) {
                        avgHeight = Math.max(avgHeight, (double)this.maxYAllowed.get().intValue());
                    }
                }
                int parentHeight = pieces.get(0).m_73547_().m_162396_();
                int offsetAmount = (int)avgHeight - parentHeight + offsetY;
                pieces.forEach(child -> child.m_6324_(0, offsetAmount, 0));
            } else {
                pieces.clear();
            }
        } else if (this.buryingType.get() == BURYING_TYPE.LOWEST_SIDE) {
            Heightmap.Types heightMapToUse = this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG);
            BoundingBox box = pieces.get(0).m_73547_();
            BlockPos centerPos = box.m_162394_();
            int highestLandPos = Integer.MAX_VALUE;
            highestLandPos = this.terrainHeight(context, heightMapToUse, box.m_162395_(), centerPos.m_123343_(), this.minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, centerPos.m_123341_(), box.m_162401_(), this.minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, centerPos.m_123341_(), box.m_162398_(), this.minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, box.m_162399_(), centerPos.m_123343_(), this.minYAllowed, highestLandPos);
            if (this.minYAllowed.isPresent() && highestLandPos == Integer.MAX_VALUE) {
                highestLandPos = this.minYAllowed.get();
            }
            if (!(this.cannotSpawnInLiquid || heightMapToUse != Heightmap.Types.OCEAN_FLOOR_WG && heightMapToUse != Heightmap.Types.OCEAN_FLOOR)) {
                int maxHeightForSubmerging = context.f_226622_().m_6337_() - box.m_71057_();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            } else {
                highestLandPos = Math.max(highestLandPos, context.f_226622_().m_6337_());
            }
            this.offsetToNewHeight(context, offsetY, pieces, box, highestLandPos);
        }
    }

    private int terrainHeight(Structure.GenerationContext context, Heightmap.Types heightMapToUse, int x, int z, Optional<Integer> minYAllowed, int highestLandPos) {
        int landPos = context.f_226622_().m_223235_(x, z, heightMapToUse, context.f_226629_(), context.f_226624_());
        if (minYAllowed.isPresent()) {
            if (landPos >= minYAllowed.get()) {
                highestLandPos = landPos;
            }
        } else {
            highestLandPos = Math.min(highestLandPos, landPos);
        }
        return highestLandPos;
    }

    private void offsetToNewHeight(Structure.GenerationContext context, int offsetY, List<PoolElementStructurePiece> pieces, BoundingBox box, int highestLandPos) {
        if (this.maxYAllowed.isPresent() && box.m_162400_() + offsetY < this.minYAllowed.get()) {
            highestLandPos = Math.max(highestLandPos, this.maxYAllowed.get());
        }
        if (this.minYAllowed.isPresent() && box.m_162396_() + offsetY < this.minYAllowed.get()) {
            highestLandPos = Math.min(highestLandPos, this.minYAllowed.get());
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int heightDiff = highestLandPos - box.m_162396_();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.m_6324_(0, heightDiff + offsetY, 0);
        }
    }

    public StructureType<?> m_213658_() {
        return MVSStructures.GENERIC_JIGSAW_STRUCTURE.get();
    }

    public static enum BURYING_TYPE implements StringRepresentable
    {
        LOWEST_CORNER("LOWEST_CORNER"),
        AVERAGE_LAND("AVERAGE_LAND"),
        LOWEST_SIDE("LOWEST_SIDE");

        private final String name;
        private static final Map<String, BURYING_TYPE> BY_NAME;

        private BURYING_TYPE(String name) {
            this.name = name;
        }

        public static BURYING_TYPE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
                BURYING_TYPE[] var1;
                for (BURYING_TYPE type : var1 = BURYING_TYPE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

