/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.smallships.SmallShipsMod;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.math.Kalkuel;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class ShipContainerScreen
extends AbstractContainerScreen<ShipContainerMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("smallships", "textures/gui/ship_inventory.png");
    public static final int FONT_COLOR = 0x404040;
    private final int rowCount;
    private final int pageCount;
    private final int pageIndex;
    private final ContainerShip containerShip;
    private final int offset = 40;

    public ShipContainerScreen(ShipContainerMenu shipContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)shipContainerMenu, inventory, component);
        this.f_96546_ = false;
        this.f_97727_ = 114 + ((ShipContainerMenu)this.m_6262_()).getRowCount() * 18;
        this.f_97726_ = 256;
        this.f_97731_ = this.f_97727_ - 94;
        this.containerShip = shipContainerMenu.getContainerShip();
        this.rowCount = ((ShipContainerMenu)this.m_6262_()).getRowCount();
        this.pageCount = ((ShipContainerMenu)this.m_6262_()).getPageCount();
        this.pageIndex = ((ShipContainerMenu)this.m_6262_()).getPageIndex();
    }

    public void m_6305_(@NotNull PoseStack poseStack, int i, int j, float f) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, i, j, f);
        this.m_7025_(poseStack, i, j);
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float f, int i, int j) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RESOURCE_LOCATION);
        int k = 40 + (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, k, l, 0, 0, this.f_97726_, this.rowCount * 18 + 17);
        this.m_93228_(poseStack, k, l + this.rowCount * 18 + 17, 0, 126, this.f_97726_, 96);
    }

    protected void m_7856_() {
        this.f_97735_ = 40 + (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            SmallShipsMod.LOGGER.error("Minecraft client or LocalPlayer is null?! Couldn't render page buttons.");
            return;
        }
        Button backward = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 115, this.f_97736_ + 125, 12, 12, (Component)Component.m_237113_((String)"<"), button -> ((ShipContainerMenu)this.m_6262_()).m_6366_((Player)this.f_96541_.f_91074_, -1)));
        backward.f_93623_ = this.pageCount > 1 && this.pageIndex + 1 > 1;
        Button forward = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 157, this.f_97736_ + 125, 12, 12, (Component)Component.m_237113_((String)">"), button -> ((ShipContainerMenu)this.m_6262_()).m_6366_((Player)this.f_96541_.f_91074_, 1)));
        forward.f_93623_ = this.pageCount > 1 && this.pageIndex + 1 < this.pageCount;
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int i, int j) {
        int maxSpeed;
        String unit;
        super.m_7027_(poseStack, i, j);
        String name = this.containerShip.m_5446_().getString();
        String smallShipTypeRaw = this.containerShip.m_6095_().m_20676_().getString();
        String smallShipType = smallShipTypeRaw.substring(0, 1).toUpperCase() + smallShipTypeRaw.substring(1);
        int currentPassengers = this.containerShip.m_20197_().size();
        int maxPassengers = this.containerShip.m_213801_();
        int maxAttachment = 0;
        int currentAttachment = 0;
        ContainerShip containerShip = this.containerShip;
        if (containerShip instanceof Cannonable) {
            Cannonable cannonable = (Cannonable)((Object)containerShip);
            maxAttachment = cannonable.getMaxCannonPerSide() * 2;
            currentAttachment = cannonable.getCannonCount();
        } else {
            containerShip = this.containerShip;
            if (containerShip instanceof Shieldable) {
                Shieldable shieldable = (Shieldable)((Object)containerShip);
                maxAttachment = shieldable.getMaxShieldsPerSide() * 2;
                currentAttachment = shieldable.getShields().size();
            }
        }
        int dmg = (int)(this.containerShip.m_38384_() * 100.0f / this.containerShip.getAttributes().maxHealth);
        int currentSpeed = switch ((Integer)SmallShipsConfig.Client.shipModSpeedUnit.get()) {
            default -> {
                unit = "km/h";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getKilometerPerHour(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getKilometerPerHour(this.containerShip.getSpeed()));
            }
            case 1 -> {
                unit = "m/s";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getMeterPerSecond(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getMeterPerSecond(this.containerShip.getSpeed()));
            }
            case 2 -> {
                unit = "knots";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getKnots(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getKnots(this.containerShip.getSpeed()));
            }
            case 3 -> {
                unit = "mph";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getMilesPerHour(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getMilesPerHour(this.containerShip.getSpeed()));
            }
        };
        int leftPos = 260;
        int leftPos2 = 323;
        int topPos = 38;
        int gap = 14;
        poseStack.m_85836_();
        poseStack.m_85841_(0.7f, 0.7f, 1.0f);
        String attachment = this.containerShip instanceof Shieldable ? "Shields:" : "Cannons:";
        this.f_96547_.m_92883_(poseStack, "Name:", (float)leftPos, (float)(topPos + gap * 0), 0x404040);
        this.f_96547_.m_92883_(poseStack, "Type:", (float)leftPos, (float)(topPos + gap * 1), 0x404040);
        this.f_96547_.m_92883_(poseStack, "Crew:", (float)leftPos, (float)(topPos + gap * 2), 0x404040);
        this.f_96547_.m_92883_(poseStack, "Speed " + unit + ":", (float)leftPos, (float)(topPos + gap * 3), 0x404040);
        this.f_96547_.m_92883_(poseStack, "Damage:", (float)leftPos, (float)(topPos + gap * 4), 0x404040);
        this.f_96547_.m_92883_(poseStack, attachment, (float)leftPos, (float)(topPos + gap * 5), 0x404040);
        this.f_96547_.m_92883_(poseStack, name, (float)leftPos2, (float)(topPos + gap * 0), 0x404040);
        this.f_96547_.m_92883_(poseStack, smallShipType, (float)leftPos2, (float)(topPos + gap * 1), 0x404040);
        this.f_96547_.m_92883_(poseStack, currentPassengers + "/" + maxPassengers, (float)leftPos2, (float)(topPos + gap * 2), 0x404040);
        this.f_96547_.m_92883_(poseStack, currentSpeed + "/" + maxSpeed, (float)leftPos2, (float)(topPos + gap * 3), 0x404040);
        this.f_96547_.m_92883_(poseStack, dmg + "%", (float)leftPos2, (float)(topPos + gap * 4), 0x404040);
        this.f_96547_.m_92883_(poseStack, currentAttachment + "/" + maxAttachment, (float)leftPos2, (float)(topPos + gap * 5), 0x404040);
        poseStack.m_85849_();
        if (this.pageCount > 1) {
            this.f_96547_.m_92883_(poseStack, this.pageIndex + 1 + "/" + this.pageCount, 133.0f - (float)Mth.m_14107_((double)Math.log10(this.pageCount)) * 6.0f, (float)(this.rowCount * 18 + 19), 0x404040);
        }
    }
}

