/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.net.MalformedURLException;
import java.net.URL;
import me.edoren.skin_changer.common.SharedPool;
import me.edoren.skin_changer.server.SkinProviderController;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SkinsCommand {
    static final Component ISSUER = Component.m_237113_((String)"SkinChanger");

    public static ArgumentBuilder<CommandSourceStack, ?> setCommand(Function3<CommandSourceStack, Player, String, Integer> setFunction, Function<CommandContext<CommandSourceStack>, Player> getTarget) {
        return Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"arg", (ArgumentType)MessageArgument.m_96832_()).executes(context -> (Integer)setFunction.apply((CommandSourceStack)context.getSource(), (Player)getTarget.apply(context), MessageArgument.m_96835_((CommandContext)context, (String)"arg").getString())));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> cleanCommand(Function2<CommandSourceStack, Player, Integer> cleanFunction, Function<CommandContext<CommandSourceStack>, Player> getTarget) {
        return Commands.m_82127_((String)"clear").executes(context -> (Integer)cleanFunction.apply((CommandSourceStack)context.getSource(), (Player)getTarget.apply(context)));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skin").then(SkinsCommand.setCommand(SkinsCommand::setPlayerSkin, context -> ((CommandSourceStack)context.getSource()).m_81375_()))).then(SkinsCommand.cleanCommand(SkinsCommand::cleanPlayerSkin, context -> ((CommandSourceStack)context.getSource()).m_81375_()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(SkinsCommand.setCommand(SkinsCommand::setPlayerSkin, context -> EntityArgument.m_91474_((CommandContext)context, (String)"target")))).then(SkinsCommand.cleanCommand(SkinsCommand::cleanPlayerSkin, context -> EntityArgument.m_91474_((CommandContext)context, (String)"target"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cape").then(SkinsCommand.setCommand(SkinsCommand::setPlayerCape, context -> ((CommandSourceStack)context.getSource()).m_81375_()))).then(SkinsCommand.cleanCommand(SkinsCommand::cleanPlayerCape, context -> ((CommandSourceStack)context.getSource()).m_81375_()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(SkinsCommand.setCommand(SkinsCommand::setPlayerCape, context -> EntityArgument.m_91474_((CommandContext)context, (String)"target")))).then(SkinsCommand.cleanCommand(SkinsCommand::cleanPlayerCape, context -> EntityArgument.m_91474_((CommandContext)context, (String)"target"))))));
    }

    private static Integer setPlayerSkin(CommandSourceStack source, Entity targetEntity, String arg) {
        MinecraftServer sourcePlayer = source.m_81377_();
        if (source.m_81373_() != null) {
            sourcePlayer = source.m_81373_();
        }
        Player targetPlayer = (Player)targetEntity;
        try {
            URL url = new URL(arg);
            return SkinsCommand.setPlayerSkinByURL((CommandSource)sourcePlayer, targetPlayer, url);
        }
        catch (MalformedURLException e) {
            return SkinsCommand.setPlayerSkinByName((CommandSource)sourcePlayer, targetPlayer, arg);
        }
    }

    private static Integer setPlayerSkinByName(CommandSource sourcePlayer, Player targetPlayer, String playerName) {
        sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Loading skin...")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerSkinByName(targetPlayer.m_36316_(), playerName, true)) {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Could not load the skin")}));
            } else {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Skin loaded successfully")}));
            }
        });
        return 1;
    }

    private static Integer setPlayerSkinByURL(CommandSource sourcePlayer, Player targetPlayer, URL url) {
        sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Loading skin...")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerSkinByURL(targetPlayer.m_36316_(), url, true)) {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Could not load the skin")}));
            } else {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Skin loaded successfully")}));
            }
        });
        return 1;
    }

    private static Integer setPlayerCape(CommandSourceStack source, Entity targetEntity, String arg) {
        MinecraftServer sourcePlayer = source.m_81377_();
        if (source.m_81373_() != null) {
            sourcePlayer = source.m_81373_();
        }
        Player targetPlayer = (Player)targetEntity;
        try {
            URL url = new URL(arg);
            return SkinsCommand.setPlayerCapeByURL((CommandSource)sourcePlayer, targetPlayer, url);
        }
        catch (MalformedURLException e) {
            return SkinsCommand.setPlayerCapeByName((CommandSource)sourcePlayer, targetPlayer, arg);
        }
    }

    private static Integer setPlayerCapeByName(CommandSource sourcePlayer, Player targetPlayer, String playerName) {
        sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Loading cape...")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerCapeByName(targetPlayer.m_36316_(), playerName, true)) {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Could not load the cape")}));
            } else {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Cape loaded successfully")}));
            }
        });
        return 1;
    }

    private static Integer setPlayerCapeByURL(CommandSource sourcePlayer, Player targetPlayer, URL url) {
        sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Loading cape...")}));
        SharedPool.get().execute(() -> {
            if (!SkinProviderController.GetInstance().setPlayerCapeByURL(targetPlayer.m_36316_(), url, true)) {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Could not load the cape")}));
            } else {
                sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Cape loaded successfully")}));
            }
        });
        return 1;
    }

    private static Integer cleanPlayerSkin(CommandSourceStack source, Entity targetEntity) throws CommandSyntaxException {
        Player sourcePlayer = (Player)source.m_81374_();
        Player targetPlayer = (Player)targetEntity;
        sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Removing skin...")}));
        SharedPool.get().execute(() -> {
            SkinProviderController.GetInstance().cleanPlayerSkin(targetPlayer.m_36316_());
            sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Skin removed successfully")}));
        });
        return 1;
    }

    private static Integer cleanPlayerCape(CommandSourceStack source, Entity targetEntity) throws CommandSyntaxException {
        Player sourcePlayer = (Player)source.m_81374_();
        Player targetPlayer = (Player)targetEntity;
        sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Removing cape...")}));
        SharedPool.get().execute(() -> {
            SkinProviderController.GetInstance().cleanPlayerCape(targetPlayer.m_36316_());
            sourcePlayer.m_213846_((Component)Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{ISSUER, Component.m_237113_((String)"Cape removed successfully")}));
        });
        return 1;
    }

    @FunctionalInterface
    static interface Function3<T, U, V, R> {
        public R apply(T var1, U var2, V var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface Function<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface Function2<T, U, R> {
        public R apply(T var1, U var2) throws CommandSyntaxException;
    }
}

