/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.server;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import me.edoren.skin_changer.common.SharedPool;
import me.edoren.skin_changer.common.messages.PlayerSkinRequestMessage;
import me.edoren.skin_changer.server.SkinProviderController;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public class ServerMessageHandler {
    public static void onMessageReceived(PlayerSkinRequestMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            LogManager.getLogger().warn("PlayerSkinRequestMessage received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        if (!message.isMessageValid()) {
            LogManager.getLogger().warn("PlayerSkinRequestMessage was invalid" + message.toString());
            return;
        }
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            LogManager.getLogger().warn("EntityPlayer was null when PlayerSkinRequestMessage was received");
        }
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> ServerMessageHandler.processMessage(message, sendingPlayer)));
    }

    static void processMessage(PlayerSkinRequestMessage message, ServerPlayer sendingPlayer) {
        SharedPool.execute(() -> {
            GameProfile profile = message.getPlayer().toGameProfile();
            LogManager.getLogger().info("Requested skin for player {}[{}]", (Object)profile.getName(), (Object)profile.getId());
            if (!SkinProviderController.GetInstance().getPlayerSkin(profile, sendingPlayer)) {
                SkinProviderController.GetInstance().setPlayerSkinByName(profile, message.getPlayer().getName(), false);
            }
        });
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return "1.0".equals(protocolVersion);
    }
}

