/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.server;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.edoren.skin_changer.server.SkinProviderController;
import me.edoren.skin_changer.server.providers.CrafatarCapeProvider;
import me.edoren.skin_changer.server.providers.CrafatarSkinProvider;
import me.edoren.skin_changer.server.providers.MineskinSkinProvider;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class ServerController {
    private static ServerController singleInstance = null;

    public static ServerController GetInstance() {
        if (singleInstance == null) {
            singleInstance = new ServerController();
        }
        return singleInstance;
    }

    private ServerController() {
    }

    public void setServer(MinecraftServer server) {
        Path savesFolder = server.m_129843_(LevelResource.f_78182_);
        File skinChangerFolder = Paths.get(savesFolder.toString(), "skin_changer").normalize().toFile();
        SkinProviderController.GetInstance().setSaveFolder(skinChangerFolder);
        SkinProviderController.GetInstance().clearSkinProviders();
        SkinProviderController.GetInstance().clearCapeProviders();
        SkinProviderController.GetInstance().registerSkinProvider(new CrafatarSkinProvider());
        SkinProviderController.GetInstance().registerSkinProvider(new MineskinSkinProvider());
        SkinProviderController.GetInstance().registerCapeProvider(new CrafatarCapeProvider());
    }
}

