/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.common.messages;

import java.util.Vector;
import me.edoren.skin_changer.common.models.PlayerModel;
import me.edoren.skin_changer.common.models.PlayerSkinModel;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.LogManager;

public class PlayerSkinUpdateMessage {
    private Vector<PlayerSkinModel> playerSkinData;
    private boolean messageIsValid;

    public PlayerSkinUpdateMessage(Vector<PlayerSkinModel> playerSkinData) {
        this.playerSkinData = playerSkinData;
        this.messageIsValid = true;
    }

    public Vector<PlayerSkinModel> getAllSkinData() {
        return this.playerSkinData;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    PlayerSkinUpdateMessage() {
        this.messageIsValid = false;
    }

    public static PlayerSkinUpdateMessage decode(FriendlyByteBuf buf) {
        PlayerSkinUpdateMessage ret = new PlayerSkinUpdateMessage();
        try {
            int size = buf.readInt();
            ret.playerSkinData = new Vector();
            ret.playerSkinData.ensureCapacity(size);
            for (int i = 0; i != size; ++i) {
                int bufferSize = buf.readInt();
                String name = buf.m_130136_(bufferSize);
                bufferSize = buf.readInt();
                String uuid = buf.m_130136_(bufferSize);
                byte[] skin = null;
                bufferSize = buf.readInt();
                if (bufferSize > 0) {
                    skin = new byte[bufferSize];
                    buf.readBytes(skin);
                }
                byte[] cape = null;
                bufferSize = buf.readInt();
                if (bufferSize > 0) {
                    cape = new byte[bufferSize];
                    buf.readBytes(cape);
                }
                ret.playerSkinData.add(new PlayerSkinModel(new PlayerModel(name, uuid), skin, cape));
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            LogManager.getLogger().warn("Exception while reading PlayerSkinUpdateMessage: " + e);
            ret.messageIsValid = false;
            e.printStackTrace();
            return ret;
        }
        ret.messageIsValid = true;
        return ret;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeInt(this.playerSkinData.size());
        for (int i = 0; i != this.playerSkinData.size(); ++i) {
            PlayerSkinModel player = this.playerSkinData.get(i);
            buf.writeInt(player.getPlayer().getName().length());
            buf.m_130070_(player.getPlayer().getName());
            buf.writeInt(player.getPlayer().getId().length());
            buf.m_130070_(player.getPlayer().getId());
            int bufferSize = player.getSkin() != null ? player.getSkin().length : 0;
            buf.writeInt(bufferSize);
            if (bufferSize > 0) {
                buf.writeBytes(player.getSkin());
            }
            bufferSize = player.getCape() != null ? player.getCape().length : 0;
            buf.writeInt(bufferSize);
            if (bufferSize <= 0) continue;
            buf.writeBytes(player.getCape());
        }
    }
}

