/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.common.messages;

import me.edoren.skin_changer.common.models.PlayerModel;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.LogManager;

public class PlayerSkinRequestMessage {
    private PlayerModel player;
    private boolean messageIsValid;

    public PlayerSkinRequestMessage(PlayerModel player) {
        this.player = player;
        this.messageIsValid = true;
    }

    public PlayerModel getPlayer() {
        return this.player;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    PlayerSkinRequestMessage() {
        this.messageIsValid = false;
    }

    public static PlayerSkinRequestMessage decode(FriendlyByteBuf buf) {
        PlayerSkinRequestMessage ret = new PlayerSkinRequestMessage();
        try {
            int bufferSize = buf.readInt();
            String name = buf.m_130136_(bufferSize);
            bufferSize = buf.readInt();
            String uuid = buf.m_130136_(bufferSize);
            ret.player = new PlayerModel(name, uuid);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            LogManager.getLogger().warn("Exception while reading PlayerSkinUpdateMessage: " + e);
            ret.messageIsValid = false;
            e.printStackTrace();
            return ret;
        }
        ret.messageIsValid = true;
        return ret;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeInt(this.player.getName().length());
        buf.m_130070_(this.player.getName());
        buf.writeInt(this.player.getId().length());
        buf.m_130070_(this.player.getId());
    }
}

