/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.client;

import java.util.Optional;
import java.util.Vector;
import java.util.function.Supplier;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.messages.PlayerSkinUpdateMessage;
import me.edoren.skin_changer.common.models.PlayerSkinModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public class ClientMessageHandler {
    public static void onMessageReceived(PlayerSkinUpdateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            LogManager.getLogger().warn("PlayerSkinUpdateMessage received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        if (!message.isMessageValid()) {
            LogManager.getLogger().warn("PlayerSkinUpdateMessage was invalid" + message);
            return;
        }
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (clientWorld.isEmpty()) {
            LogManager.getLogger().warn("PlayerSkinUpdateMessage context could not provide a Level.");
            return;
        }
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientMessageHandler.processMessage(message)));
    }

    private static void processMessage(PlayerSkinUpdateMessage message) {
        Vector<PlayerSkinModel> skinData = message.getAllSkinData();
        if (skinData.isEmpty()) {
            SkinLoaderService.GetInstance().clear();
            return;
        }
        for (PlayerSkinModel playerData : skinData) {
            SkinLoaderService.GetInstance().loadPlayerSkin(playerData.getPlayer(), playerData.getSkin());
            SkinLoaderService.GetInstance().loadPlayerCape(playerData.getPlayer(), playerData.getCape());
        }
    }

    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return "1.0".equals(protocolVersion);
    }
}

