/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildfireEntity
extends Monster
implements IAnimatable {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    public WildfireEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 500;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new WildfireAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(@NotNull ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    private <E extends IAnimatable> PlayState predicate(@NotNull AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.wildfire.idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.wildfire.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(@NotNull AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6126_() {
        return true;
    }

    protected void m_8024_() {
        LivingEntity livingentity;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = (float)this.f_19796_.m_216328_(0.5, 6.891);
        }
        if ((livingentity = this.m_5448_()) != null && livingentity.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset && this.m_6779_(livingentity)) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        super.m_8024_();
    }

    public boolean m_142535_(float p_149683_, float p_149684_, @NotNull DamageSource damageSource) {
        return false;
    }

    public boolean m_6060_() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    void setCharged(boolean p_32241_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_32241_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    static class WildfireAttackGoal
    extends Goal {
        private final WildfireEntity wildfire;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public WildfireAttackGoal(WildfireEntity wildfire) {
            this.wildfire = wildfire;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.wildfire.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.wildfire.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.wildfire.setCharged(false);
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.wildfire.m_5448_();
            if (livingentity != null) {
                boolean flag = this.wildfire.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.wildfire.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.wildfire.m_7327_((Entity)livingentity);
                    }
                    this.wildfire.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.wildfire.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.wildfire.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.wildfire.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            this.wildfire.setCharged(true);
                        } else if (this.attackStep <= 10) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.wildfire.setCharged(false);
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.wildfire.m_20067_()) {
                                this.wildfire.f_19853_.m_5898_(null, 1018, this.wildfire.m_20183_(), 0);
                            }
                            for (int i = 0; i < 3; ++i) {
                                SmallFireball smallfireball = new SmallFireball(this.wildfire.f_19853_, (LivingEntity)this.wildfire, this.wildfire.m_217043_().m_216328_(d1, 2.297 * d4), d2, this.wildfire.m_217043_().m_216328_(d3, 2.297 * d4));
                                smallfireball.m_6034_(smallfireball.m_20185_(), this.wildfire.m_20227_(0.5) + 0.5, smallfireball.m_20189_());
                                this.wildfire.f_19853_.m_7967_((Entity)smallfireball);
                            }
                        }
                    }
                    this.wildfire.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.wildfire.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.wildfire.m_21133_(Attributes.f_22277_);
        }
    }
}

