/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block.entity;

import net.hexnowloading.hexfortress.registry.HFBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LockedChestBlockEntity
extends BlockEntity
implements IAnimatable {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public LockedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HFBlockEntities.LOCKED_CHEST.get(), pos, state);
    }

    protected void m_183515_(CompoundTag nbt) {
        this.trySaveLootTable(nbt);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        this.tryLoadLootTable(nbt);
        super.m_142466_(nbt);
    }

    protected boolean tryLoadLootTable(CompoundTag nbt) {
        if (nbt.m_128425_(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new ResourceLocation(nbt.m_128461_(LOOT_TABLE_TAG));
            this.lootTableSeed = nbt.m_128454_(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(CompoundTag nbt) {
        if (this.lootTable == null) {
            return false;
        }
        nbt.m_128359_(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            nbt.m_128356_(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    private <E extends IAnimatable> PlayState predicate(@NotNull AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("closed", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

