/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block;

import net.hexnowloading.hexfortress.block.entity.ResistanceCancelerBlockEntity;
import net.hexnowloading.hexfortress.registry.HFBlockEntities;
import net.hexnowloading.hexfortress.registry.HFItems;
import net.hexnowloading.hexfortress.registry.HFProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ResistanceCancelerBlock
extends BaseEntityBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty LOCKED = HFProperties.LOCKED;
    private static final BooleanProperty ACTIVATED = HFProperties.ACTIVATED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final IntegerProperty RANGE = HFProperties.RANGE;

    public ResistanceCancelerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LOCKED, (Comparable)Boolean.FALSE)).m_61124_((Property)ACTIVATED, (Comparable)Boolean.TRUE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)RANGE, (Comparable)Integer.valueOf(32)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{LOCKED}).m_61104_(new Property[]{ACTIVATED}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{RANGE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static boolean isKey(ItemStack itemStack) {
        return itemStack.m_150930_((Item)HFItems.BLAZE_KEY.get());
    }

    public static boolean isLavaBucket(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42448_);
    }

    public static boolean isWaterBucket(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42447_);
    }

    public void unlockBlockState(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HFProperties.LOCKED, (Comparable)Boolean.valueOf(false)), 0);
    }

    public void lockBlockState(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HFProperties.LOCKED, (Comparable)Boolean.valueOf(true)), 0);
    }

    public void deactivateBlockState(BlockState state, Level level, BlockPos pos) {
        this.playSound(level, pos, state, SoundEvents.f_11738_);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HFProperties.ACTIVATED, (Comparable)Boolean.valueOf(false)), 0);
    }

    public void activateBlockState(BlockState state, Level level, BlockPos pos) {
        this.playSound(level, pos, state, SoundEvents.f_11736_);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HFProperties.ACTIVATED, (Comparable)Boolean.valueOf(true)), 0);
    }

    public void increaseRange(Player player, BlockState state, Level level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)HFProperties.RANGE) < 64) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HFProperties.RANGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HFProperties.RANGE) + 1)), 0);
            player.m_5661_((Component)Component.m_237110_((String)"warning.hexfortress.resistance_canceler_increase_range", (Object[])new Object[]{(Integer)state.m_61143_((Property)HFProperties.RANGE) + 1}), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"warning.hexfortress.resistance_canceler_increase_range_cancel"), true);
        }
    }

    public void decreaseRange(Player player, BlockState state, Level level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)HFProperties.RANGE) > 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HFProperties.RANGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HFProperties.RANGE) - 1)), 0);
            player.m_5661_((Component)Component.m_237110_((String)"warning.hexfortress.resistance_canceler_decrease_range", (Object[])new Object[]{(Integer)state.m_61143_((Property)HFProperties.RANGE) - 1}), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"warning.hexfortress.resistance_canceler_decrease_range_cancel"), true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.f_46443_) {
            ItemStack itemStack = player.m_21120_(hand);
            if (player.m_150110_().f_35937_) {
                if (ResistanceCancelerBlock.isKey(itemStack)) {
                    if (((Boolean)state.m_61143_((Property)HFProperties.LOCKED)).booleanValue()) {
                        this.unlockBlockState(state, level, pos);
                    } else {
                        this.lockBlockState(state, level, pos);
                    }
                } else if (((Boolean)state.m_61143_((Property)HFProperties.ACTIVATED)).booleanValue()) {
                    if (ResistanceCancelerBlock.isLavaBucket(itemStack)) {
                        this.increaseRange(player, state, level, pos);
                    } else if (ResistanceCancelerBlock.isWaterBucket(itemStack)) {
                        this.decreaseRange(player, state, level, pos);
                    } else {
                        this.deactivateBlockState(state, level, pos);
                    }
                } else {
                    this.activateBlockState(state, level, pos);
                }
            } else if (((Boolean)state.m_61143_((Property)HFProperties.LOCKED)).booleanValue()) {
                if (ResistanceCancelerBlock.isKey(itemStack)) {
                    this.playSound(level, pos, state, SoundEvents.f_11686_);
                    itemStack.m_41774_(1);
                    this.unlockBlockState(state, level, pos);
                    return InteractionResult.CONSUME;
                }
                player.m_5661_((Component)Component.m_237115_((String)"warning.hexfortress.locked_resistance_canceler"), true);
                this.playSound(level, pos, state, SoundEvents.f_12209_);
            } else if (((Boolean)state.m_61143_((Property)HFProperties.ACTIVATED)).booleanValue()) {
                if (ResistanceCancelerBlock.isLavaBucket(itemStack)) {
                    this.increaseRange(player, state, level, pos);
                } else if (ResistanceCancelerBlock.isWaterBucket(itemStack)) {
                    this.decreaseRange(player, state, level, pos);
                } else {
                    this.deactivateBlockState(state, level, pos);
                }
            } else {
                this.activateBlockState(state, level, pos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ResistanceCancelerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)HFBlockEntities.RESISTANCE_CANCELER.get()), ResistanceCancelerBlockEntity::tick);
    }

    private void playSound(Level level, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        double d0 = pos.m_123341_();
        double d1 = pos.m_123342_();
        double d2 = pos.m_123343_();
        if (((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                if (!source.m_188499_()) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + source.m_188500_() * 1.5, d1 + source.m_188500_() * 1.5, d2 + source.m_188500_() * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ResistanceCancelerBlockEntity(pos, state);
    }
}

