/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block;

import net.hexnowloading.hexfortress.block.entity.LockedChestBlockEntity;
import net.hexnowloading.hexfortress.registry.HFBlocks;
import net.hexnowloading.hexfortress.registry.HFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LockedChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_X = Block.m_49796_((double)1.5, (double)0.0, (double)1.0, (double)14.5, (double)14.0, (double)15.0);
    private static final VoxelShape SHAPE_Z = Block.m_49796_((double)1.0, (double)0.0, (double)1.5, (double)15.0, (double)14.0, (double)14.5);

    public LockedChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        switch (((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            default: {
                return SHAPE_X;
            }
            case Z: 
        }
        return SHAPE_Z;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public static boolean isKey(ItemStack itemStack) {
        return itemStack.m_150930_((Item)HFItems.BLAZE_KEY.get());
    }

    private void unlockBlockState(BlockState state, Level level, BlockPos pos) {
        CompoundTag lootTable = level.m_7702_(pos).m_187480_().m_6426_();
        level.m_7731_(pos, ((Block)HFBlocks.DUNGEON_CHEST.get()).m_152465_(state), 0);
        BlockEntity chestEntity = level.m_7702_(pos);
        chestEntity.m_142466_(lootTable);
        chestEntity.m_6596_();
    }

    private void playSound(Level level, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.f_46443_) {
            ItemStack itemStack = player.m_21120_(hand);
            if (LockedChestBlock.isKey(itemStack)) {
                this.playSound(level, pos, state, SoundEvents.f_11686_);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.unlockBlockState(state, level, pos);
                return InteractionResult.CONSUME;
            }
            player.m_5661_((Component)Component.m_237115_((String)"warning.hexfortress.locked_chest"), true);
            this.playSound(level, pos, state, SoundEvents.f_11748_);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockedChestBlockEntity(pos, state);
    }
}

