/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block;

import net.hexnowloading.hexfortress.registry.HFBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExplosiveBarrelBlock
extends FallingBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ExplosiveBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level level, BlockPos blockPos, Block block, BlockPos signalPos, boolean moved) {
        if (level.m_46753_(blockPos)) {
            this.onCaughtFire(state, level, blockPos, null, null);
            this.explode(level, blockPos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void explode(Level level, BlockPos pos) {
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)HFBlocks.WITHER_LEAVES.get())) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(level, (double)pos.m_123341_(), (double)pos.m_123342_() - 1.0, (double)pos.m_123343_());
            areaEffectCloud.m_19712_(5.0f);
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19734_(areaEffectCloud.m_19748_() / 2);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19615_, 40));
            level.m_7967_((Entity)areaEffectCloud);
        }
        level.m_7471_(pos, false);
        level.m_46511_((Entity)null, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 4.0f, Explosion.BlockInteraction.BREAK);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.f_46443_) {
            BlockPos blockpos = blockHitResult.m_82425_();
            Entity entity = projectile.m_37282_();
            if (projectile.m_6060_() && projectile.m_142265_(level, blockpos)) {
                this.onCaughtFire(state, level, blockpos, null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                this.explode(level, blockpos);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        this.onCaughtFire(state, level, pos, hitResult.m_82434_(), (LivingEntity)player);
        this.explode(level, pos);
        Item item = itemstack.m_41720_();
        if (!player.m_7500_()) {
            if (itemstack.m_150930_(Items.f_42409_)) {
                itemstack.m_41622_(1, (LivingEntity)player, p_57425_ -> p_57425_.m_21190_(hand));
            } else {
                itemstack.m_41774_(1);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state1, BlockState state2, FallingBlockEntity fallingBlockEntity) {
        this.explode(level, pos);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, level, pos, explosion);
        FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
        this.m_6788_(fallingblockentity);
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        double d0 = pos.m_123341_();
        double d1 = pos.m_123342_();
        double d2 = pos.m_123343_();
        for (int i = 0; i < 1; ++i) {
            if (!source.m_188499_()) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.5, d1 + 1.0, d2 + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType computationType) {
        return false;
    }
}

