/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.dungeons_plus.data.DPTags;
import com.legacy.dungeons_plus.entities.WarpedAxeEntity;
import com.legacy.dungeons_plus.items.DPItem;
import com.legacy.dungeons_plus.registry.DPSoundEvents;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class WarpedAxeItem
extends AxeItem
implements DPItem {
    public static final String TELEPORT_KEY = "teleport";
    public static final String CROUCH_KEY = "crouch";
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float ATTACK_SPEED = -3.2f;
    public static final float SHOOT_POWER = 2.5f;
    private static final Lazy<Multimap<Attribute, AttributeModifier>> ATTRIBUTES = Lazy.of(() -> {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "attack_damage", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "attack_speed", (double)-3.2f, AttributeModifier.Operation.ADDITION));
        return builder.build();
    });

    public WarpedAxeItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? (Multimap)ATTRIBUTES.get() : ImmutableMultimap.of();
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int useTime) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int totalUseTime = this.m_8105_(stack) - useTime;
            if (totalUseTime >= 10 && !level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, u -> u.m_21190_(user.m_7655_()));
                WarpedAxeEntity axe = new WarpedAxeEntity(level, (LivingEntity)player, stack);
                if (player.m_6047_()) {
                    axe.setTeleportsOwner(false);
                }
                axe.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                boolean isCreative = player.m_7500_();
                if (isCreative) {
                    axe.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.m_7967_((Entity)axe);
                level.m_6269_((Player)null, (Entity)axe, (SoundEvent)DPSoundEvents.WARPED_AXE_THROW.get(), SoundSource.PLAYERS, 0.8f, 0.9f);
                if (!isCreative) {
                    player.m_150109_().m_36057_(stack);
                }
                player.m_21011_(player.m_7655_(), true);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack handItem = player.m_21120_(hand);
        if (handItem.m_41773_() >= handItem.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)handItem);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)handItem);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity user) {
        stack.m_41622_(1, user, u -> u.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44955_ || enchantment == Enchantments.f_44981_ || enchantment instanceof DamageEnchantment || RegistryHelper.isInTag((Registry)Registry.f_122825_, DPTags.Enchantments.WARPED_AXE_APPLICABLE, (Object)enchantment);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag showAdvanced) {
        super.m_7373_(stack, level, tooltip, showAdvanced);
        tooltip.addAll(this.getDescription(stack, new String[]{TELEPORT_KEY, CROUCH_KEY}));
    }
}

