/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LiquidBlockProcessor
extends StructureProcessor {
    public static final Codec<LiquidBlockProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockState.f_61039_.fieldOf("target_block_output").forGetter(config -> config.targetBlockOutput)).apply((Applicative)instance, instance.stable(LiquidBlockProcessor::new)));
    public final BlockState targetBlock;
    public final BlockState targetBlockOutput;

    private LiquidBlockProcessor(BlockState targetBlock, BlockState targetBlockOutput) {
        this.targetBlock = targetBlock;
        this.targetBlockOutput = targetBlockOutput;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_.m_60713_(this.targetBlock.m_60734_())) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)new ChunkPos(blockInfoGlobal.f_74675_))) {
                return blockInfoGlobal;
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, this.targetBlockOutput, blockInfoGlobal.f_74677_);
            if (levelReader instanceof WorldGenRegion) {
                worldGenRegion = (WorldGenRegion)levelReader;
                worldGenRegion.m_186469_(blockInfoGlobal.f_74675_, (Fluid)Fluids.f_76195_, 0);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.LIQUID_BLOCK_PROCESSOR;
    }
}

