/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.world.processors;

import com.finallion.graveyard.init.TGProcessors;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class RemoveWaterloggedCryptProcessor
extends StructureProcessor {
    public static final Codec<RemoveWaterloggedCryptProcessor> CODEC = Codec.unit(RemoveWaterloggedCryptProcessor::new);

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        if (infoIn2.f_74676_.m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)infoIn2.f_74676_.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            ChunkPos currentChunkPos = new ChunkPos(infoIn2.f_74675_);
            ChunkAccess currentChunk = world.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
            int sectionYIndex = currentChunk.m_151564_(infoIn2.f_74675_.m_123342_());
            if (sectionYIndex < 0) {
                return infoIn2;
            }
            LevelChunkSection currChunkSection = currentChunk.m_183278_(sectionYIndex);
            if (this.getFluidState(world, infoIn2.f_74675_).m_205070_(FluidTags.f_13131_)) {
                this.setBlockState(currChunkSection, infoIn2.f_74675_, infoIn2.f_74676_);
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                Optional<BlockState> blockState;
                mutable.m_122190_((Vec3i)infoIn2.f_74675_).m_122173_(direction);
                if (currentChunkPos.f_45578_ != mutable.m_123341_() >> 4 || currentChunkPos.f_45579_ != mutable.m_123343_() >> 4) {
                    currentChunkPos = new ChunkPos((BlockPos)mutable);
                    currentChunk = world.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
                    sectionYIndex = currentChunk.m_151564_(mutable.m_123342_());
                    if (sectionYIndex < 0) {
                        return infoIn2;
                    }
                    currChunkSection = currentChunk.m_183278_(sectionYIndex);
                }
                if (!this.getFluidState(currChunkSection, (BlockPos)mutable).m_205070_(FluidTags.f_13131_) || !(blockState = this.getBlockState(currChunkSection, (BlockPos)mutable)).isPresent() || blockState.get().m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.get().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) continue;
                this.setBlockState(currChunkSection, (BlockPos)mutable, Blocks.f_152550_.m_49966_());
            }
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> m_6953_() {
        return TGProcessors.REMOVE_WATERLOGGED_CRYPT;
    }

    private FluidState getFluidState(LevelReader world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int sectionYIndex = world.m_151564_(pos.m_123342_());
        LevelChunkSection chunkSection = chunk.m_183278_(sectionYIndex);
        return this.getFluidState(chunkSection, pos);
    }

    private FluidState getFluidState(LevelChunkSection chunkSection, BlockPos pos) {
        if (chunkSection == null) {
            return Fluids.f_76191_.m_76145_();
        }
        return chunkSection.m_63007_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_()));
    }

    private Optional<BlockState> setBlockState(LevelChunkSection chunkSection, BlockPos pos, BlockState state) {
        if (chunkSection == null) {
            return Optional.empty();
        }
        return Optional.of(chunkSection.m_62991_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_()), state, false));
    }

    private Optional<BlockState> getBlockState(LevelChunkSection chunkSection, BlockPos pos) {
        if (chunkSection == null) {
            return Optional.empty();
        }
        return Optional.of(chunkSection.m_62982_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_())));
    }
}

