/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.entities.AngerableGraveyardEntity;
import com.finallion.graveyard.entities.LichEntity;
import com.finallion.graveyard.entities.ai.goals.RevenantMeleeAttackGoal;
import com.finallion.graveyard.init.TGSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RevenantEntity
extends AngerableGraveyardEntity
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final UUID SLOWNESS_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A4");
    private static final AttributeModifier SLOWNESS_EFFECT;
    private static final EntityDataAccessor<Integer> ATTACK_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> REANIMATE_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> ANIMATION;
    private static final EntityDataAccessor<Boolean> CAN_REANIMATE;
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder FAKE_DEATH_ANIMATION = new AnimationBuilder().addAnimation("fake_death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder RUNNING_ANIMATION = new AnimationBuilder().addAnimation("running", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder REANIMATE_ANIMATION = new AnimationBuilder().addAnimation("reanimate", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    protected static final int ANIMATION_IDLE = 0;
    protected static final int ANIMATION_WALK = 1;
    protected static final int ANIMATION_DEATH = 2;
    protected static final int ANIMATION_RUNNING = 3;
    protected static final int ANIMATION_MELEE = 4;
    protected static final int ANIMATION_REANIMATE = 5;
    protected static final int ANIMATION_FAKE_DEATH = 6;
    public final int ATTACK_ANIMATION_DURATION = 9;
    public final int REANIMATE_DURATION = 120;

    public RevenantEntity(EntityType<? extends RevenantEntity> entityType, Level world) {
        super(entityType, world, "revenant");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(REANIMATE_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(CAN_REANIMATE, (Object)true);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RevenantMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{LichEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 3.5).m_22268_(Attributes.f_22279_, 0.155).m_22268_(Attributes.f_22277_, 25.0);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
            event.getController().setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 6 && this.getReanimateAnimTimer() > 39) {
            event.getController().setAnimation(this.FAKE_DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 5 && this.getReanimateAnimTimer() == 39) {
            event.getController().setAnimation(this.REANIMATE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 4 && this.getAttackAnimTimer() == 8 && this.m_5912_() && !this.m_21224_() && !((double)this.m_21223_() < 0.01) && this.getReanimateAnimTimer() <= 0) {
            this.setAttackAnimTimer(7);
            event.getController().setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        if ((this.getAnimationState() == 1 || event.isMoving()) && this.getAttackAnimTimer() <= 0 && this.getReanimateAnimTimer() <= 0) {
            if (this.m_5912_() && !this.m_20069_()) {
                event.getController().setAnimation(this.RUNNING_ANIMATION);
            } else {
                event.getController().setAnimation(this.WALK_ANIMATION);
            }
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 0 && this.getAttackAnimTimer() <= 0 && !event.isMoving() && this.getReanimateAnimTimer() <= 0) {
            event.getController().setAnimation(this.IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 0 && this.getAttackAnimTimer() > 0) {
            this.setAnimationState(4);
            return PlayState.STOP;
        }
        if (this.getAttackAnimTimer() <= 0 && !this.m_21224_() && !((double)this.m_21223_() < 0.01) && this.getAnimationState() != 5) {
            this.setAnimationState(0);
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    protected void m_8024_() {
        int animTimer;
        if (this.getAttackAnimTimer() == 9) {
            this.setAnimationState(4);
        }
        if (this.getReanimateAnimTimer() > 40) {
            this.setAnimationState(6);
        }
        if (this.getReanimateAnimTimer() == 40) {
            this.setAnimationState(5);
        }
        if (this.getAttackAnimTimer() > 0) {
            animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.getReanimateAnimTimer() > 0) {
            animTimer = this.getReanimateAnimTimer() - 1;
            this.setReanimateAnimTimer(animTimer);
        }
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
        if (this.getReanimateAnimTimer() > 0) {
            this.m_21563_().m_24946_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!entityAttributeInstance.m_22109_(SLOWNESS_EFFECT)) {
                entityAttributeInstance.m_22118_(SLOWNESS_EFFECT);
            }
        } else if (entityAttributeInstance.m_22109_(SLOWNESS_EFFECT)) {
            entityAttributeInstance.m_22130_(SLOWNESS_EFFECT);
        }
        super.m_8107_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 30 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19311_ || source == DamageSource.f_19310_ || source == DamageSource.f_19313_ || source == DamageSource.f_19317_ || source == DamageSource.f_19307_) {
            this.setCanReanimate(false);
            this.setReanimateAnimTimer(0);
        }
        if (amount >= this.m_21223_() && this.canReanimate() && this.f_19796_.m_188503_(3) == 0) {
            this.setCanReanimate(false);
            this.setReanimateAnimTimer(120);
            return false;
        }
        if (this.getReanimateAnimTimer() > 0) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public void m_8032_() {
        this.m_5496_((SoundEvent)TGSounds.REVENANT_AMBIENT.get(), 1.0f, 1.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_((SoundEvent)TGSounds.REVENANT_HURT.get(), 1.0f, 1.0f);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TGSounds.REVENANT_DEATH.get();
    }

    public float m_6100_() {
        return 1.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)TGSounds.REVENANT_STEP.get(), 0.15f, 1.0f);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION, (Object)state);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.f_19804_.m_135381_(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getReanimateAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(REANIMATE_ANIM_TIMER);
    }

    public void setReanimateAnimTimer(int time) {
        this.f_19804_.m_135381_(REANIMATE_ANIM_TIMER, (Object)time);
    }

    public boolean canReanimate() {
        return (Boolean)this.f_19804_.m_135370_(CAN_REANIMATE);
    }

    public void setCanReanimate(boolean bool) {
        this.f_19804_.m_135381_(CAN_REANIMATE, (Object)bool);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("canReanimate", this.canReanimate());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setCanReanimate(nbt.m_128471_("canReanimate"));
    }

    static {
        ATTACK_ANIM_TIMER = SynchedEntityData.m_135353_(RevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        REANIMATE_ANIM_TIMER = SynchedEntityData.m_135353_(RevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ANIMATION = SynchedEntityData.m_135353_(RevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CAN_REANIMATE = SynchedEntityData.m_135353_(RevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SLOWNESS_EFFECT = new AttributeModifier(SLOWNESS_ID, "Slowness effect", -0.3, AttributeModifier.Operation.ADDITION);
    }
}

