/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.entities.ai.goals.NightmareMeleeAttackGoal;
import com.finallion.graveyard.init.TGAdvancements;
import com.finallion.graveyard.init.TGSounds;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class NightmareEntity
extends HostileGraveyardEntity
implements IAnimatable,
NeutralMob {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_WALK = 1;
    protected static final byte ANIMATION_DEATH = 3;
    protected static final byte ANIMATION_ATTACK = 5;
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACK_ANIM_TIMER = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final int ATTACK_ANIMATION_DURATION = 20;
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT = SynchedEntityData.m_135353_(NightmareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID target;
    private int angerTime;
    private int ageWhenTargetSet;

    public NightmareEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world, "nightmare");
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
        this.f_19804_.m_135372_(ATTACK_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
    }

    public int getAnimationState() {
        return ((Byte)this.f_19804_.m_135370_(ANIMATION)).byteValue();
    }

    public void setState(byte time) {
        this.f_19804_.m_135381_(ANIMATION, (Object)time);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ChasePlayerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new NightmareMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new TeleportTowardsPlayerGoal(this, arg_0 -> ((NightmareEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void m_8024_() {
        float f;
        if (this.getAttackAnimTimer() == 20) {
            this.setAnimation((byte)5);
        }
        if (this.getAttackAnimTimer() > 0) {
            int animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.f_19853_.m_46461_() && this.f_19797_ >= this.ageWhenTargetSet + 600 && (f = this.m_213856_()) > 0.5f && this.f_19853_.m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        this.f_20899_ = false;
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) >= 1024.0) {
                this.m_21662_();
            }
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
        super.m_8107_();
    }

    @Override
    public void m_7380_(CompoundTag p_32520_) {
        super.m_7380_(p_32520_);
        this.m_21678_(p_32520_);
    }

    @Override
    public void m_7378_(CompoundTag p_32511_) {
        super.m_7378_(p_32511_);
        this.m_147285_(this.f_19853_, p_32511_);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        boolean isMoving;
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        if (this.m_21224_()) {
            event.getController().setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 5 && this.getAttackAnimTimer() == 19 && this.m_5912_() && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
            this.setAttackAnimTimer(18);
            event.getController().setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        if ((this.getAnimationState() == 1 || event.isMoving()) && this.getAttackAnimTimer() <= 0) {
            event.getController().setAnimation(this.WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 0 && this.getAttackAnimTimer() <= 0 && !event.isMoving()) {
            event.getController().setAnimation(this.IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 0 && this.getAttackAnimTimer() > 0) {
            this.setAnimation((byte)5);
            return PlayState.STOP;
        }
        if (this.getAttackAnimTimer() <= 0 && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
            this.setAnimation((byte)0);
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.19).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 28 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6469_(DamageSource p_32494_, float p_32495_) {
        if (this.m_6673_(p_32494_)) {
            return false;
        }
        if (p_32494_ instanceof IndirectEntityDamageSource) {
            return false;
        }
        return super.m_6469_(p_32494_, p_32495_);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public int getAttackAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.f_19804_.m_135381_(ATTACK_ANIM_TIMER, (Object)time);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_8032_() {
        this.m_5496_((SoundEvent)TGSounds.NIGHTMARE_AMBIENT.get(), 1.0f, -10.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_((SoundEvent)TGSounds.NIGHTMARE_HURT.get(), 1.0f, -10.0f);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TGSounds.NIGHTMARE_DEATH.get();
    }

    public float m_6100_() {
        return -10.0f;
    }

    boolean isLookingAtMe(Player p_32535_) {
        ItemStack itemstack = (ItemStack)p_32535_.m_150109_().f_35975_.get(3);
        if (itemstack.m_150930_(Blocks.f_50143_.m_5456_())) {
            return false;
        }
        Vec3 vec3 = p_32535_.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - p_32535_.m_20185_(), this.m_20188_() - p_32535_.m_20188_(), this.m_20189_() - p_32535_.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        if (d1 > 1.0 - 0.025 / d0) {
            return p_32535_.m_142582_((Entity)this);
        }
        return false;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.55f;
    }

    boolean teleportTowards(Entity entity) {
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(4) - 2) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (flag2 && !this.m_20067_()) {
                this.m_5496_(SoundEvents.f_11852_, 1.0f, -10.0f);
            }
            return flag2;
        }
        return false;
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int p_21673_) {
        this.angerTime = p_21673_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.target;
    }

    public void m_6925_(@javax.annotation.Nullable UUID p_32509_) {
        this.target = p_32509_;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            this.m_7870_(0);
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
        } else {
            this.ageWhenTargetSet = this.f_19797_;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
        }
    }

    public void m_21268_(@Nullable LivingEntity adversary) {
        ServerPlayer player;
        if (adversary instanceof ServerPlayer && (player = (ServerPlayer)adversary).m_21023_(MobEffects.f_19610_)) {
            TGAdvancements.KILL_WHILE_BLINDED.trigger(player);
        }
        super.m_6703_(adversary);
    }

    static class ChasePlayerGoal
    extends Goal {
        private final NightmareEntity nightmare;
        @javax.annotation.Nullable
        private LivingEntity target;

        public ChasePlayerGoal(NightmareEntity p_32550_) {
            this.nightmare = p_32550_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.nightmare.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.nightmare);
            return d0 > 256.0 ? false : this.nightmare.isLookingAtMe((Player)this.target);
        }

        public void m_8056_() {
            this.nightmare.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.nightmare.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class TeleportTowardsPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final NightmareEntity nightmare;
        @javax.annotation.Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public TeleportTowardsPlayerGoal(NightmareEntity p_32573_, @javax.annotation.Nullable Predicate<LivingEntity> p_32574_) {
            super((Mob)p_32573_, Player.class, 10, false, false, p_32574_);
            this.nightmare = p_32573_;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> p_32573_.isLookingAtMe((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.nightmare.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.nightmare);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
            this.nightmare.setBeingStaredAt();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.nightmare.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.nightmare.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.nightmare, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.nightmare.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.nightmare.m_20159_()) {
                    if (this.nightmare.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.nightmare) <= 384.0 && this.f_26050_ != null && this.f_26050_.m_20280_((Entity)this.nightmare) > 24.0) {
                            this.f_26050_.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100));
                            this.nightmare.teleportTowards((Entity)this.f_26050_);
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.nightmare) > 256.0 && this.teleportTime++ >= this.m_183277_(80) && this.nightmare.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

