/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blockentities.BrazierBlockEntity;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BrazierBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty LIT;
    public static final BooleanProperty WATERLOGGED;
    public static final ToIntFunction<BlockState> STATE_TO_LUMINANCE;
    protected static final VoxelShape SHAPE;
    private SimpleParticleType fireType;

    public BrazierBlock(BlockBehaviour.Properties settings, SimpleParticleType fireType) {
        super(settings);
        this.fireType = fireType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState p_152822_, Level p_152823_, BlockPos p_152824_, Player p_152825_, InteractionHand p_152826_, BlockHitResult p_152827_) {
        if (p_152825_.m_150110_().f_35938_ && p_152825_.m_21120_(p_152826_).m_41619_() && ((Boolean)p_152822_.m_61143_((Property)LIT)).booleanValue()) {
            BrazierBlock.extinguish(p_152825_, p_152822_, (LevelAccessor)p_152823_, p_152824_);
            return InteractionResult.m_19078_((boolean)p_152823_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public FluidState m_5888_(BlockState p_152844_) {
        return (Boolean)p_152844_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152844_);
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_51240_) {
        BlockPos blockpos;
        Level levelaccessor = p_51240_.m_43725_();
        boolean flag = levelaccessor.m_6425_(blockpos = p_51240_.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_7417_(BlockState p_51298_, Direction p_51299_, BlockState p_51300_, LevelAccessor p_51301_, BlockPos p_51302_, BlockPos p_51303_) {
        if (((Boolean)p_51298_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51301_.m_186469_(p_51302_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51301_));
        }
        return p_51299_ == Direction.DOWN ? p_51298_ : super.m_7417_(p_51298_, p_51299_, p_51300_, p_51301_, p_51302_, p_51303_);
    }

    public boolean m_7361_(LevelAccessor p_152805_, BlockPos p_152806_, BlockState p_152807_, FluidState p_152808_) {
        if (!((Boolean)p_152807_.m_61143_((Property)WATERLOGGED)).booleanValue() && p_152808_.m_76152_() == Fluids.f_76193_) {
            BlockState blockstate = (BlockState)p_152807_.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)p_152807_.m_61143_((Property)LIT)).booleanValue()) {
                BrazierBlock.extinguish(null, blockstate, p_152805_, p_152806_);
            } else {
                p_152805_.m_7731_(p_152806_, blockstate, 3);
            }
            p_152805_.m_186469_(p_152806_, p_152808_.m_76152_(), p_152808_.m_76152_().m_6718_((LevelReader)p_152805_));
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState p_51309_, BlockGetter p_51310_, BlockPos p_51311_, CollisionContext p_51312_) {
        return SHAPE;
    }

    public void m_214162_(BlockState p_51287_, Level p_51288_, BlockPos pos, RandomSource p_51290_) {
        if (((Boolean)p_51287_.m_61143_((Property)LIT)).booleanValue()) {
            if (p_51290_.m_188503_(20) == 0) {
                p_51288_.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + p_51290_.m_188501_(), p_51290_.m_188501_() * 0.7f + 0.6f, false);
            }
            for (int i = 0; i < 20; ++i) {
                p_51288_.m_7106_((ParticleOptions)this.fireType, (double)pos.m_123341_() + 0.25 + Math.abs(p_51290_.m_188500_() - 0.5), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.25 + Math.abs(p_51290_.m_188500_() - 0.5), 0.0, 0.01, 0.0);
            }
        }
    }

    public void m_5581_(Level p_51244_, BlockState p_51245_, BlockHitResult p_51246_, Projectile p_51247_) {
        BlockPos blockpos = p_51246_.m_82425_();
        if (!p_51244_.f_46443_ && p_51247_.m_6060_() && p_51247_.m_142265_(p_51244_, blockpos) && !((Boolean)p_51245_.m_61143_((Property)LIT)).booleanValue() && !((Boolean)p_51245_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51244_.m_7731_(blockpos, (BlockState)p_51245_.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public BlockEntity m_142194_(BlockPos p_153064_, BlockState p_153065_) {
        return new BrazierBlockEntity(p_153064_, p_153065_);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51305_) {
        p_51305_.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public static void extinguish(@javax.annotation.Nullable Player p_151900_, BlockState p_151901_, LevelAccessor p_151902_, BlockPos p_151903_) {
        BrazierBlock.setLit(p_151902_, p_151901_, p_151903_, false);
        if (p_151901_.m_60734_() instanceof BrazierBlock) {
            RandomSource random = p_151902_.m_213780_();
            p_151902_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p_151903_.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)p_151903_.m_123342_() + 0.4, (double)p_151903_.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
            p_151902_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)p_151903_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)p_151903_.m_123342_() + random.m_188500_() + random.m_188500_(), (double)p_151903_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        }
        p_151902_.m_5594_((Player)null, p_151903_, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_151902_.m_142346_((Entity)p_151900_, GameEvent.f_157792_, p_151903_);
    }

    public static void spawnSmokeParticle(Level p_51252_, BlockPos p_51253_, boolean p_51255_) {
        RandomSource random = p_51252_.m_213780_();
        SimpleParticleType simpleparticletype = ParticleTypes.f_123777_;
        p_51252_.m_6485_((ParticleOptions)simpleparticletype, true, (double)p_51253_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)p_51253_.m_123342_() + random.m_188500_() + random.m_188500_(), (double)p_51253_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        if (p_51255_) {
            p_51252_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p_51253_.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)p_51253_.m_123342_() + 0.4, (double)p_51253_.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    private static void setLit(LevelAccessor p_151919_, BlockState p_151920_, BlockPos p_151921_, boolean p_151922_) {
        p_151919_.m_7731_(p_151921_, (BlockState)p_151920_.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(p_151922_)), 11);
    }

    static {
        SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
        LIT = BlockStateProperties.f_61443_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        STATE_TO_LUMINANCE = state -> (Boolean)state.m_61143_((Property)LIT) != false ? 11 : 0;
    }
}

