/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.web.config.validators;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefulconfig.web.config.validators.Validator;
import com.teamresourceful.resourcefulconfig.web.info.UserJwtPayload;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public record HashedPasswordValidator(HashType type, String hash) implements Validator
{
    public static final Codec<HashedPasswordValidator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HashType.CODEC.fieldOf("algorithm").forGetter(HashedPasswordValidator::type), (App)Codec.STRING.fieldOf("input").forGetter(HashedPasswordValidator::hash)).apply((Applicative)instance, HashedPasswordValidator::new));

    @Override
    public boolean test(UserJwtPayload userJwtPayload) {
        String password = userJwtPayload.password();
        HashFunction function = switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case HashType.SHA1 -> Hashing.sha1();
            case HashType.SHA256 -> Hashing.sha256();
            case HashType.SHA512 -> Hashing.sha512();
            case HashType.MD5 -> Hashing.md5();
        };
        return function.hashString((CharSequence)password, StandardCharsets.UTF_8).toString().equals(this.hash);
    }

    @Override
    public String id() {
        return "hashed";
    }

    public static enum HashType {
        SHA1,
        SHA256,
        SHA512,
        MD5;

        public static final Codec<HashType> CODEC;

        public static DataResult<HashType> fromString(String string) {
            return switch (string.toLowerCase(Locale.ROOT)) {
                case "sha1" -> DataResult.success((Object)((Object)SHA1));
                case "sha256" -> DataResult.success((Object)((Object)SHA256));
                case "sha512" -> DataResult.success((Object)((Object)SHA512));
                case "md5" -> DataResult.success((Object)((Object)MD5));
                default -> DataResult.error((String)("Unknown hash type: " + string));
            };
        }

        static {
            CODEC = Codec.STRING.comapFlatMap(HashType::fromString, Enum::toString);
        }
    }
}

