/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.forge;

import com.teamresourceful.resourcefulconfig.common.annotations.Category;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.annotations.Config;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.annotations.InlineCategory;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.forge.ForgeResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.forge.ForgeResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.web.info.ResourcefulWebConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public final class ForgeConfigParser {
    public static ForgeResourcefulConfig parseConfig(Class<?> config) throws Exception {
        Config data = config.getAnnotation(Config.class);
        if (data == null) {
            throw new Exception("Config class " + config.getName() + " is missing @Config annotation!");
        }
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        return ForgeConfigParser.createConfig(ForgeConfigParser.parseData(config, "resourcefulconfig.config", Config.class, builder), data.value(), builder.build());
    }

    private static ForgeResourcefulConfig createConfig(TempConfig config, @Nullable String file, ForgeConfigSpec spec) {
        LinkedHashMap<String, ForgeResourcefulConfig> subConfigs = new LinkedHashMap<String, ForgeResourcefulConfig>();
        config.configs.forEach((key, value) -> subConfigs.put((String)key, ForgeConfigParser.createConfig(value, null, null)));
        return new ForgeResourcefulConfig(config.web(), new LinkedHashMap<String, ForgeResourcefulConfigEntry>(config.entries), subConfigs, file, config.translation, spec);
    }

    private static TempConfig parseData(Class<?> config, String translation, Class<? extends Annotation> annotation, ForgeConfigSpec.Builder builder) {
        ParsingUtils.assertValidClass(config, annotation);
        TempConfig builtConfig = new TempConfig(config, translation);
        for (Field field : config.getDeclaredFields()) {
            Annotation data;
            InlineCategory inlineCategory = field.getAnnotation(InlineCategory.class);
            if (inlineCategory != null) {
                data = field.getType().getAnnotation(Category.class);
                if (data == null) continue;
                builder.push(data.id());
                builtConfig.configs.put(data.id(), ForgeConfigParser.parseData(field.getType(), data.translation(), Category.class, builder));
                builder.pop();
                continue;
            }
            data = ParsingUtils.assertEntry(field);
            if (data == null) continue;
            Comment comment = field.getAnnotation(Comment.class);
            if (comment != null) {
                builder.comment(comment.value());
            }
            builtConfig.entries.put(data.id(), ForgeResourcefulConfigEntry.create((ConfigEntry)data, field, builder));
        }
        for (AnnotatedElement annotatedElement : config.getDeclaredClasses()) {
            Category data = ((Class)annotatedElement).getAnnotation(Category.class);
            if (data == null) continue;
            builder.push(data.id());
            builtConfig.configs.put(data.id(), ForgeConfigParser.parseData(annotatedElement, data.translation(), Category.class, builder));
            builder.pop();
        }
        return builtConfig;
    }

    private record TempConfig(ResourcefulWebConfig web, Map<String, ForgeResourcefulConfigEntry> entries, Map<String, TempConfig> configs, String translation) {
        private TempConfig(Class<?> config, String translation) {
            this(ResourcefulWebConfig.of(config), new LinkedHashMap<String, ForgeResourcefulConfigEntry>(), new LinkedHashMap<String, TempConfig>(), translation);
        }
    }
}

