/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.universal.shader;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.Ref;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.StringsKt;
import su.plo.voice.universal.shader.UniformType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsu/plo/voice/universal/shader/ShaderTransformer;", "", "vertexFormat", "Lcom/mojang/blaze3d/vertex/VertexFormat;", "(Lcom/mojang/blaze3d/vertex/VertexFormat;)V", "attributes", "", "", "getAttributes", "()Ljava/util/List;", "samplers", "", "getSamplers", "()Ljava/util/Set;", "uniforms", "", "Lsu/plo/voice/universal/shader/UniformType;", "getUniforms", "()Ljava/util/Map;", "transform", "originalSource", "plasmovoice-forge-1.19.2"})
@SourceDebugExtension(value={"SMAP\nMCShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MCShader.kt\ngg/essential/universal/shader/ShaderTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1045#2:326\n1855#2,2:327\n1855#2,2:329\n1789#2,3:331\n*S KotlinDebug\n*F\n+ 1 MCShader.kt\ngg/essential/universal/shader/ShaderTransformer\n*L\n261#1:326\n262#1:327,2\n267#1:329,2\n300#1:331,3\n*E\n"})
public final class ShaderTransformer {
    @Nullable
    private final VertexFormat vertexFormat;
    @NotNull
    private final List<String> attributes;
    @NotNull
    private final Set<String> samplers;
    @NotNull
    private final Map<String, UniformType> uniforms;

    public ShaderTransformer(@Nullable VertexFormat vertexFormat) {
        this.vertexFormat = vertexFormat;
        this.attributes = new ArrayList();
        this.samplers = new LinkedHashSet();
        this.uniforms = new LinkedHashMap();
    }

    @NotNull
    public final List<String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final Set<String> getSamplers() {
        return this.samplers;
    }

    @NotNull
    public final Map<String, UniformType> getUniforms() {
        return this.uniforms;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String transform(@NotNull String originalSource) {
        Object object;
        boolean vert;
        Intrinsics.checkNotNullParameter(originalSource, "originalSource");
        Ref.ObjectRef<String> source2 = new Ref.ObjectRef<String>();
        source2.element = originalSource;
        source2.element = StringsKt.replace$default((String)source2.element, "gl_ModelViewProjectionMatrix", "gl_ProjectionMatrix * gl_ModelViewMatrix", false, 4, null);
        source2.element = StringsKt.replace$default((String)source2.element, "texture2D", "texture", false, 4, null);
        Map replacements = new LinkedHashMap();
        List transformed = new ArrayList();
        transformed.add("#version 150");
        boolean frag = StringsKt.contains$default((CharSequence)source2.element, "gl_FragColor", false, 2, null);
        boolean bl = vert = !frag;
        if (frag) {
            transformed.add("out vec4 uc_FragColor;");
            replacements.put("gl_FragColor", "uc_FragColor");
        }
        if (vert && StringsKt.contains$default((CharSequence)source2.element, "gl_FrontColor", false, 2, null)) {
            transformed.add("out vec4 uc_FrontColor;");
            replacements.put("gl_FrontColor", "uc_FrontColor");
        }
        if (frag && StringsKt.contains$default((CharSequence)source2.element, "gl_Color", false, 2, null)) {
            transformed.add("in vec4 uc_FrontColor;");
            replacements.put("gl_Color", "uc_FrontColor");
        }
        if (vert) {
            List newAttributes = new ArrayList();
            ShaderTransformer.transform$replaceAttribute(source2, replacements, newAttributes, "gl_Vertex", "vec3", "uc_Position", "vec4(uc_Position, 1.0)");
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, newAttributes, "gl_Color", "vec4", null, null, 96, null);
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, newAttributes, "gl_MultiTexCoord0.st", "vec2", "uc_UV0", null, 64, null);
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, newAttributes, "gl_MultiTexCoord1.st", "vec2", "uc_UV1", null, 64, null);
            ShaderTransformer.transform$replaceAttribute$default(source2, replacements, newAttributes, "gl_MultiTexCoord2.st", "vec2", "uc_UV2", null, 64, null);
            if (this.vertexFormat != null) {
                Iterable $this$sortedBy$iv = newAttributes;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(this){
                    final /* synthetic */ ShaderTransformer this$0;
                    {
                        this.this$0 = shaderTransformer;
                    }

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(ShaderTransformer.access$getVertexFormat$p(this.this$0).m_166911_().indexOf((Object)StringsKt.removePrefix((String)it.getFirst(), (CharSequence)"uc_")));
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ShaderTransformer.access$getVertexFormat$p(this.this$0).m_166911_().indexOf((Object)StringsKt.removePrefix((String)it.getFirst(), (CharSequence)"uc_")));
                    }
                });
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Pair)element$iv;
                    boolean bl2 = false;
                    this.attributes.add((String)it.getFirst());
                    transformed.add(it.getSecond());
                }
            } else {
                $this$forEach$iv = newAttributes;
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv;
                    element$iv = object.next();
                    it = (Pair)element$iv;
                    boolean bl3 = false;
                    this.attributes.add((String)it.getFirst());
                    transformed.add(it.getSecond());
                }
            }
        }
        ShaderTransformer.transform$replaceUniform$default(source2, replacements, this, transformed, "gl_ModelViewMatrix", UniformType.Mat4, "ModelViewMat", null, 128, null);
        ShaderTransformer.transform$replaceUniform$default(source2, replacements, this, transformed, "gl_ProjectionMatrix", UniformType.Mat4, "ProjMat", null, 128, null);
        for (String line : StringsKt.lines((CharSequence)source2.element)) {
            Object object2;
            List list = transformed;
            if (StringsKt.startsWith$default(line, "#version", false, 2, null)) continue;
            if (StringsKt.startsWith$default(line, "varying ", false, 2, null)) {
                object2 = (frag ? "in " : "out ") + StringsKt.substringAfter$default(line, "varying ", null, 2, null);
            } else if (StringsKt.startsWith$default(line, "uniform ", false, 2, null)) {
                object = new char[]{';'};
                CharSequence charSequence = StringsKt.trimEnd(line, object);
                object = new String[]{" "};
                List $i$f$forEach = StringsKt.split$default(charSequence, (String[])object, false, 0, 6, null);
                String glslType = (String)$i$f$forEach.get(1);
                String name = (String)$i$f$forEach.get(2);
                if (Intrinsics.areEqual(glslType, "sampler2D")) {
                    this.samplers.add(name);
                } else {
                    this.uniforms.put(name, UniformType.Companion.fromGlsl(glslType));
                }
                object2 = line;
            } else {
                void $this$fold$iv;
                Iterable $i$f$forEach = replacements.entrySet();
                List list2 = list;
                boolean $i$f$fold = false;
                String accumulator$iv = line;
                for (Object element$iv : $this$fold$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    String acc = accumulator$iv;
                    boolean bl4 = false;
                    String needle = (String)entry.getKey();
                    String replacement = (String)entry.getValue();
                    accumulator$iv = StringsKt.replace$default(acc, needle, replacement, false, 4, null);
                }
                object2 = accumulator$iv;
                list = list2;
            }
            list.add(object2);
        }
        return CollectionsKt.joinToString$default(transformed, "\n", null, null, 0, null, null, 62, null);
    }

    private static final void transform$replaceAttribute(Ref.ObjectRef<String> source2, Map<String, String> replacements, List<Pair<String, String>> newAttributes, String needle, String type, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)source2.element, needle, false, 2, null)) {
            replacements.put(needle, replacement);
            newAttributes.add(TuplesKt.to(replacementName, "in " + type + " " + replacementName + ";"));
        }
    }

    static /* synthetic */ void transform$replaceAttribute$default(Ref.ObjectRef objectRef, Map map2, List list, String string, String string2, String object, String string3, int n, Object object2) {
        if ((n & 0x20) != 0) {
            object = "uc_" + StringsKt.substringAfter$default(string, "_", null, 2, null);
        }
        if ((n & 0x40) != 0) {
            string3 = object;
        }
        ShaderTransformer.transform$replaceAttribute(objectRef, map2, list, string, string2, (String)object, string3);
    }

    private static final void transform$replaceUniform(Ref.ObjectRef<String> source2, Map<String, String> replacements, ShaderTransformer this$0, List<String> transformed, String needle, UniformType type, String replacementName, String replacement) {
        if (StringsKt.contains$default((CharSequence)source2.element, needle, false, 2, null)) {
            replacements.put(needle, replacement);
            if (!this$0.uniforms.containsKey(replacementName)) {
                this$0.uniforms.put(replacementName, type);
                transformed.add("uniform " + type.getGlslName() + " " + replacementName + ";");
            }
        }
    }

    static /* synthetic */ void transform$replaceUniform$default(Ref.ObjectRef objectRef, Map map2, ShaderTransformer shaderTransformer, List list, String string, UniformType uniformType, String string2, String string3, int n, Object object) {
        if ((n & 0x80) != 0) {
            string3 = string2;
        }
        ShaderTransformer.transform$replaceUniform(objectRef, map2, shaderTransformer, list, string, uniformType, string2, string3);
    }

    public static final /* synthetic */ VertexFormat access$getVertexFormat$p(ShaderTransformer $this) {
        return $this.vertexFormat;
    }
}

