/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.PublicKey;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.event.player.PlayerActivationDistanceUpdateEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.proto.packets.tcp.clientbound.AnimatedActionBarPacket;
import su.plo.voice.proto.packets.tcp.clientbound.DistanceVisualizePacket;

public abstract class BaseVoicePlayer<P extends McPlayer>
implements VoicePlayer {
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    protected final P instance;
    protected boolean voiceDisabled;
    protected boolean microphoneMuted;
    @Nullable
    protected String modVersion;
    private PublicKey publicKey;
    private final Map<UUID, Integer> distanceByActivationId = Maps.newConcurrentMap();
    private final Set<ServerActivation> activeActivations = Sets.newConcurrentHashSet();
    private final Map<UUID, Long> lastActivationSequenceNumber = Maps.newConcurrentMap();

    @Override
    public void sendPacket(@NotNull Packet<?> packet) {
        this.instance.sendPacket("plasmo:voice/v2", PacketTcpCodec.encode(packet));
    }

    @Override
    public boolean isVoiceDisabled() {
        this.checkVoiceChat();
        return this.voiceDisabled;
    }

    @Override
    public boolean isMicrophoneMuted() {
        this.checkVoiceChat();
        return this.microphoneMuted;
    }

    @Override
    @NotNull
    public Optional<String> getModVersion() {
        if (!this.hasVoiceChat()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.modVersion);
    }

    @Override
    public int getActivationDistanceById(@NotNull UUID activationId) {
        return this.distanceByActivationId.getOrDefault(activationId, -1);
    }

    @Override
    public void visualizeDistance(int radius, int hexColor) {
        this.sendPacket(new DistanceVisualizePacket(radius, hexColor, null));
    }

    @Override
    public void visualizeDistance(@NotNull Pos3d position, int radius, int hexColor) {
        this.sendPacket(new DistanceVisualizePacket(radius, hexColor, position));
    }

    @Override
    public void sendAnimatedActionBar(@NotNull McTextComponent text) {
        if (!this.hasVoiceChat()) {
            this.instance.sendActionBar(text);
            return;
        }
        String json2 = this.voiceServer.getMinecraftServer().getTextConverter().convertToJson((McCommandSource)this.instance, text);
        this.sendPacket(new AnimatedActionBarPacket(json2));
    }

    @Override
    public Optional<PublicKey> getPublicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    public void setActivationDistance(@NotNull ServerActivation activation, int distance) {
        Integer oldDistance = this.distanceByActivationId.put(activation.getId(), distance);
        this.voiceServer.getEventBus().fire(new PlayerActivationDistanceUpdateEvent(this, activation, distance, oldDistance == null ? -1 : oldDistance));
    }

    public void removeActivationDistance(@NotNull ServerActivation activation) {
        Integer oldDistance = this.distanceByActivationId.remove(activation.getId());
        this.voiceServer.getEventBus().fire(new PlayerActivationDistanceUpdateEvent(this, activation, -1, oldDistance == null ? -1 : oldDistance));
    }

    protected void checkVoiceChat() {
        if (!this.hasVoiceChat()) {
            throw new IllegalStateException("Player is not connected to UDP server");
        }
    }

    public BaseVoicePlayer(PlasmoBaseVoiceServer voiceServer, @NotNull P instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.voiceServer = voiceServer;
        this.instance = instance;
    }

    public String toString() {
        return "BaseVoicePlayer(voiceServer=" + this.voiceServer + ", instance=" + this.instance + ", voiceDisabled=" + this.voiceDisabled + ", microphoneMuted=" + this.microphoneMuted + ", modVersion=" + this.modVersion + ", distanceByActivationId=" + this.distanceByActivationId + ", activeActivations=" + this.activeActivations + ", lastActivationSequenceNumber=" + this.lastActivationSequenceNumber + ")";
    }

    @NotNull
    public P getInstance() {
        return this.instance;
    }

    public void setVoiceDisabled(boolean voiceDisabled) {
        this.voiceDisabled = voiceDisabled;
    }

    public void setMicrophoneMuted(boolean microphoneMuted) {
        this.microphoneMuted = microphoneMuted;
    }

    public void setModVersion(@Nullable String modVersion) {
        this.modVersion = modVersion;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public Set<ServerActivation> getActiveActivations() {
        return this.activeActivations;
    }

    public Map<UUID, Long> getLastActivationSequenceNumber() {
        return this.lastActivationSequenceNumber;
    }
}

