/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerBroadcastSource;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpConnection;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.AbstractIterator;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.server.audio.source.VoiceBaseServerDirectSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0014\u0010\u001f\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030 H\u0016R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerBroadcastSource;", "Lsu/plo/voice/server/audio/source/VoiceBaseServerDirectSource;", "Lsu/plo/voice/api/server/audio/source/ServerBroadcastSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "udpConnections", "Lsu/plo/voice/api/server/connection/UdpConnectionManager;", "Lsu/plo/voice/api/server/player/VoicePlayer;", "Lsu/plo/voice/api/server/socket/UdpConnection;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/server/connection/UdpConnectionManager;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;Z)V", "players", "", "getPlayers", "()Ljava/util/Collection;", "setPlayers", "(Ljava/util/Collection;)V", "getListeners", "", "sendAudioPacket", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "activationInfo", "Lsu/plo/voice/api/server/audio/capture/PlayerActivationInfo;", "sendPacket", "Lsu/plo/voice/proto/packets/Packet;", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nVoiceServerBroadcastSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerBroadcastSource.kt\nsu/plo/voice/server/audio/source/VoiceServerBroadcastSource\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,83:1\n32#2,2:84\n32#2,2:86\n*S KotlinDebug\n*F\n+ 1 VoiceServerBroadcastSource.kt\nsu/plo/voice/server/audio/source/VoiceServerBroadcastSource\n*L\n42#1:84,2\n55#1:86,2\n*E\n"})
public final class VoiceServerBroadcastSource
extends VoiceBaseServerDirectSource
implements ServerBroadcastSource {
    @Nullable
    private Collection<? extends VoicePlayer> players;

    public VoiceServerBroadcastSource(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections, @NotNull AddonContainer addon, @NotNull BaseServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(udpConnections, "udpConnections");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        super(voiceServer, udpConnections, addon, line, decoderInfo, stereo);
    }

    @Nullable
    public Collection<VoicePlayer> getPlayers() {
        return this.players;
    }

    @Override
    public void setPlayers(@Nullable Collection<? extends VoicePlayer> collection) {
        this.players = collection;
    }

    @Override
    public boolean sendAudioPacket(@NotNull SourceAudioPacket packet, @Nullable PlayerActivationInfo activationInfo) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        ServerSourceAudioPacketEvent event = new ServerSourceAudioPacketEvent(this, packet, activationInfo);
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        if (event.getResult() == ServerSourceAudioPacketEvent.Result.HANDLED) {
            return true;
        }
        packet.setSourceState((byte)this.state.get());
        if (this.dirty.compareAndSet(true, false)) {
            this.updateSourceInfo();
        }
        Iterator<UdpConnection> $this$forEach$iv = this.getListeners();
        boolean $i$f$forEach = false;
        Iterator<UdpConnection> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            UdpConnection element$iv;
            UdpConnection it = element$iv = iterator2.next();
            boolean bl = false;
            if (this.notMatchFilters(it.getPlayer())) continue;
            it.sendPacket(packet);
        }
        return true;
    }

    @Override
    public boolean sendPacket(@NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        ServerSourcePacketEvent event = new ServerSourcePacketEvent(this, packet);
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        if (event.getResult() == ServerSourcePacketEvent.Result.HANDLED) {
            return true;
        }
        Iterator<UdpConnection> $this$forEach$iv = this.getListeners();
        boolean $i$f$forEach = false;
        Iterator<UdpConnection> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            UdpConnection element$iv;
            UdpConnection it = element$iv = iterator2.next();
            boolean bl = false;
            if (this.notMatchFilters(it.getPlayer())) continue;
            it.getPlayer().sendPacket(packet);
        }
        return true;
    }

    private final Iterator<UdpConnection> getListeners() {
        Collection<VoicePlayer> collection = this.getPlayers();
        if (collection == null || (collection = collection.iterator()) == null) {
            return this.udpConnections.getConnections().iterator();
        }
        Collection<VoicePlayer> players = collection;
        return new AbstractIterator<UdpConnection>((Iterator<? extends VoicePlayer>)((Object)players), this){
            final /* synthetic */ Iterator<VoicePlayer> $players;
            final /* synthetic */ VoiceServerBroadcastSource this$0;
            {
                this.$players = $players;
                this.this$0 = $receiver;
            }

            protected void computeNext() {
                while (this.$players.hasNext()) {
                    VoicePlayer player = this.$players.next();
                    Optional<C> optional = this.this$0.udpConnections.getConnectionByPlayerId(player.getInstance().getUuid());
                    Intrinsics.checkNotNullExpressionValue(optional, "getConnectionByPlayerId(...)");
                    UdpConnection udpConnection = (UdpConnection)OptionalsKt.getOrNull(optional);
                    if (udpConnection == null) continue;
                    UdpConnection connection = udpConnection;
                    this.setNext(connection);
                    return;
                }
                this.done();
            }
        };
    }
}

