/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.api.client.event.render.HudActivationRenderEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.render.HudRenderEvent;
import su.plo.voice.proto.data.audio.capture.Activation;

public final class HudIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;

    @EventSubscribe
    public void onHudRender(@NotNull HudRenderEvent event) {
        if (!this.voiceClient.getServerInfo().isPresent() || !this.voiceClient.getUdpClientManager().getClient().isPresent() || Minecraft.m_91087_().f_91074_ == null || !((Boolean)this.config.getOverlay().getShowActivationIcon().value()).booleanValue() || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (this.voiceClient.getUdpClientManager().getClient().get().isTimedOut()) {
            this.renderIcon(event.getStack(), ResourceLocation.m_135820_((String)"plasmovoice:textures/icons/microphone_disconnected.png"));
            return;
        }
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            this.renderIcon(event.getStack(), ResourceLocation.m_135820_((String)"plasmovoice:textures/icons/speaker_disabled.png"));
            return;
        }
        if (this.voiceClient.getAudioCapture().isServerMuted()) {
            this.renderIcon(event.getStack(), ResourceLocation.m_135820_((String)"plasmovoice:textures/icons/microphone_muted.png"));
            return;
        }
        if (((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue()) {
            this.renderIcon(event.getStack(), ResourceLocation.m_135820_((String)"plasmovoice:textures/icons/microphone_disabled.png"));
            return;
        }
        List activations = (List)this.voiceClient.getActivationManager().getActivations();
        Activation currentActivation = null;
        for (int index = activations.size() - 1; index >= 0; --index) {
            ClientActivation activation = (ClientActivation)activations.get(index);
            HudActivationRenderEvent renderEvent = new HudActivationRenderEvent(activation, activation.isActive());
            this.voiceClient.getEventBus().fire(renderEvent);
            if (!renderEvent.isRender()) continue;
            currentActivation = activation;
            if (!activation.isTransitive()) break;
        }
        if (currentActivation != null) {
            this.renderIcon(event.getStack(), ResourceLocation.m_135820_((String)currentActivation.getIcon()));
        }
    }

    private void renderIcon(@NotNull PoseStack stack, @NotNull ResourceLocation iconLocation) {
        IconPosition iconPosition = (IconPosition)((Object)this.config.getOverlay().getActivationIconPosition().value());
        RenderSystem.m_69478_();
        RenderSystem.m_69456_((int)515);
        RenderUtil.bindTexture(0, iconLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85836_();
        stack.m_85837_(0.0, 0.0, 1000.0);
        RenderUtil.blit(stack, this.calcIconX(iconPosition.getX()), this.calcIconY(iconPosition.getY()), 0.0f, 0.0f, 16, 16, 16, 16);
        stack.m_85849_();
        RenderSystem.m_69461_();
    }

    private int calcIconX(Integer x) {
        Window window = Minecraft.m_91087_().m_91268_();
        if (x == null) {
            return window.m_85445_() / 2 - 8;
        }
        if (x < 0) {
            return window.m_85445_() + x - 16;
        }
        return x;
    }

    private int calcIconY(Integer y) {
        Window window = Minecraft.m_91087_().m_91268_();
        if (y == null) {
            return window.m_85446_() - 32;
        }
        if (y < 0) {
            return window.m_85446_() + y - 16;
        }
        return y;
    }

    public HudIconRenderer(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

