/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.client.gui.components.AbstractScrollbar;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.components.TextFieldWidget;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.api.audio.source.AudioSource;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.line.ClientSourceLineManager;
import su.plo.voice.api.client.event.connection.VoicePlayerConnectedEvent;
import su.plo.voice.api.client.event.connection.VoicePlayerDisconnectedEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;
import su.plo.voice.client.gui.settings.widget.VolumeSliderWidget;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;

public final class VolumeTabWidget
extends TabWidget {
    private final PlasmoVoiceClient voiceClient;
    private final ClientSourceLineManager sourceLines;
    private String currentSearch = "";

    public VolumeTabWidget(@NotNull VoiceSettingsScreen parent, @NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.voiceClient = voiceClient;
        this.sourceLines = voiceClient.getSourceLineManager();
    }

    @Override
    public void init() {
        super.init();
        this.addEntry(new TabWidget.CategoryEntry(McTextComponent.translatable("gui.plasmovoice.volume.sources", new Object[0]), 24));
        ArrayList sourceLines = Lists.newArrayList(this.sourceLines.getLines());
        Collections.reverse(sourceLines);
        sourceLines.forEach(this::createSourceLineVolume);
        this.addEntry(new TabWidget.CategoryEntry(McTextComponent.translatable("gui.plasmovoice.volume.players", new Object[0]), 24));
        this.createPlayersSearch();
        this.refreshPlayerEntries();
    }

    @EventSubscribe
    public void onPlayerConnected(@NotNull VoicePlayerConnectedEvent event) {
        Minecraft.m_91087_().execute(this::refreshPlayerEntries);
    }

    @EventSubscribe
    public void onPlayerDisconnected(@NotNull VoicePlayerDisconnectedEvent event) {
        Minecraft.m_91087_().execute(this::refreshPlayerEntries);
    }

    private void createSourceLineVolume(@NotNull ClientSourceLine sourceLine) {
        DoubleConfigEntry volumeEntry = this.config.getVoice().getVolumes().getVolume(sourceLine.getName());
        BooleanConfigEntry muteEntry = this.config.getVoice().getVolumes().getMute(sourceLine.getName());
        ArrayList buttons = Lists.newArrayList();
        Runnable updateButtons = this.createMuteButtonAction(buttons, muteEntry);
        this.addEntry(new SourceLineVolumeEntry(this, (McTextComponent)McTextComponent.translatable(sourceLine.getTranslation(), new Object[0]), (GuiAbstractWidget)this.createVolumeSlider(volumeEntry), this.createMuteButton(buttons, updateButtons, muteEntry), (ConfigEntry)volumeEntry, (ConfigEntry)muteEntry, null, ResourceLocation.m_135820_((String)sourceLine.getIcon()), (button, element) -> updateButtons.run()));
    }

    private void createPlayersSearch() {
        TextFieldWidget textField = new TextFieldWidget(0, 0, 0, 20, McTextComponent.translatable("gui.plasmovoice.volume.players_search", new Object[0]).withStyle(McTextStyle.GRAY));
        textField.setResponder(value -> {
            this.currentSearch = value.toLowerCase();
            this.refreshPlayerEntries();
        });
        this.addEntry(new TabWidget.FullWidthEntry((TabWidget)this, (GuiAbstractWidget)textField, 26));
    }

    private void refreshPlayerEntries() {
        List<AbstractScrollbar.Entry> entries2 = this.entries.stream().filter(entry -> !(entry instanceof PlayerVolumeEntry)).collect(Collectors.toList());
        this.clearEntries();
        entries2.forEach(this::addEntry);
        this.voiceClient.getServerConnection().ifPresent(connection -> {
            HashMap players = Maps.newHashMap();
            this.joinMap(players, connection.getPlayers().stream().filter(player -> player.getPlayerNick().toLowerCase().contains(this.currentSearch)).map(VoicePlayerInfo::toGameProfile).collect(Collectors.toList()));
            this.joinMap(players, this.voiceClient.getSourceLineManager().getLines().stream().map(SourceLine::getPlayers).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
            this.joinMap(players, this.voiceClient.getSourceManager().getSources().stream().map(AudioSource::getSourceInfo).filter(sourceInfo -> sourceInfo instanceof DirectSourceInfo).map(sourceInfo -> ((DirectSourceInfo)sourceInfo).getSender()).filter(Objects::nonNull).collect(Collectors.toList()));
            players.values().stream().filter(player -> !Minecraft.m_91087_().f_91074_.m_20148_().equals(player.getId())).sorted(Comparator.comparing(McGameProfile::getName)).forEach(this::createPlayerVolume);
        });
    }

    private void joinMap(Map<UUID, McGameProfile> map2, Collection<McGameProfile> joinCollection) {
        joinCollection.forEach(gameProfile -> {
            McGameProfile mapGameProfile = (McGameProfile)map2.get(gameProfile.getId());
            if (Objects.equals(gameProfile, mapGameProfile) && gameProfile.getProperties().size() > mapGameProfile.getProperties().size()) {
                map2.put(gameProfile.getId(), (McGameProfile)gameProfile);
                return;
            }
            map2.put(gameProfile.getId(), (McGameProfile)gameProfile);
        });
    }

    private void createPlayerVolume(@NotNull McGameProfile player) {
        DoubleConfigEntry volumeEntry = this.config.getVoice().getVolumes().getVolume("source_" + player.getId().toString());
        BooleanConfigEntry muteEntry = this.config.getVoice().getVolumes().getMute("source_" + player.getId().toString());
        ArrayList buttons = Lists.newArrayList();
        Runnable updateButtons = this.createMuteButtonAction(buttons, muteEntry);
        this.addEntry(new PlayerVolumeEntry(this, (GuiAbstractWidget)this.createVolumeSlider(volumeEntry), this.createMuteButton(buttons, updateButtons, muteEntry), (ConfigEntry)volumeEntry, (ConfigEntry)muteEntry, null, player, (button, element) -> updateButtons.run()));
    }

    private VolumeSliderWidget createVolumeSlider(DoubleConfigEntry volumeEntry) {
        return new VolumeSliderWidget(this.voiceClient.getHotkeys(), volumeEntry, "%", 0, 0, 100, 20);
    }

    private Runnable createMuteButtonAction(@NotNull List<Button> buttons, @NotNull ConfigEntry<Boolean> muteEntry) {
        return () -> {
            ((Button)buttons.get(0)).setVisible((Boolean)muteEntry.value() == false);
            ((Button)buttons.get(1)).setVisible((Boolean)muteEntry.value());
        };
    }

    private List<Button> createMuteButton(@NotNull List<Button> buttons, @NotNull Runnable updateButtons, @NotNull ConfigEntry<Boolean> muteEntry) {
        Button.OnPress buttonClick = button -> {
            muteEntry.set((Boolean)muteEntry.value() == false);
            updateButtons.run();
        };
        IconButton muteButton = new IconButton(0, 0, 20, 20, buttonClick, Button.NO_TOOLTIP, ResourceLocation.m_135820_((String)"plasmovoice:textures/icons/speaker_menu.png"), true);
        IconButton unmuteButton = new IconButton(0, 0, 20, 20, buttonClick, Button.NO_TOOLTIP, ResourceLocation.m_135820_((String)"plasmovoice:textures/icons/speaker_menu_disabled.png"), true);
        muteButton.setVisible(muteEntry.value() == false);
        unmuteButton.setVisible(muteEntry.value());
        buttons.add(muteButton);
        buttons.add(unmuteButton);
        return buttons;
    }

    static class SourceLineVolumeEntry<W extends GuiAbstractWidget>
    extends TabWidget.ButtonOptionEntry<W> {
        private final ResourceLocation iconLocation;
        private final ConfigEntry<Boolean> muteEntry;
        final /* synthetic */ VolumeTabWidget this$0;

        public SourceLineVolumeEntry(@NotNull McTextComponent text, @NotNull W widget, @NotNull List<Button> buttons, @NotNull ConfigEntry<?> entry, @Nullable ConfigEntry<Boolean> muteEntry, @NotNull McTextComponent tooltip, @NotNull ResourceLocation iconLocation, TabWidget.OptionResetAction<W> resetAction) {
            this.this$0 = this$0;
            super((TabWidget)this$0, text, widget, buttons, entry, tooltip, resetAction);
            this.muteEntry = muteEntry;
            this.iconLocation = iconLocation;
        }

        @Override
        protected void renderText(@NotNull PoseStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            RenderUtil.bindTexture(0, this.iconLocation);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderUtil.blit(stack, x, y + this.height / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.m_69461_();
            RenderUtil.drawString(stack, this.text, x + 20, y + this.height / 2 - RenderUtil.getFontHeight() / 2, 0xFFFFFF);
        }

        @Override
        protected boolean isDefault() {
            return this.entry.isDefault() && this.muteEntry.isDefault();
        }

        @Override
        protected void onReset(@NotNull Button button) {
            this.entry.reset();
            this.muteEntry.reset();
            if (this.element instanceof UpdatableWidget) {
                ((UpdatableWidget)((Object)this.element)).updateValue();
            }
            if (this.resetAction != null) {
                this.resetAction.onReset(this.resetButton, this.element);
            }
        }
    }

    static class PlayerVolumeEntry<W extends GuiAbstractWidget>
    extends TabWidget.ButtonOptionEntry<W> {
        private final McGameProfile player;
        private final ConfigEntry<Boolean> muteEntry;
        final /* synthetic */ VolumeTabWidget this$0;

        public PlayerVolumeEntry(@NotNull W widget, @NotNull List<Button> buttons, @NotNull ConfigEntry<?> entry, @Nullable ConfigEntry<Boolean> muteEntry, @NotNull McTextComponent tooltip, @NotNull McGameProfile player, TabWidget.OptionResetAction<W> resetAction) {
            this.this$0 = this$0;
            super((TabWidget)this$0, (McTextComponent)McTextComponent.literal(player.getName()), widget, buttons, entry, tooltip, resetAction, 30);
            this.muteEntry = muteEntry;
            this.player = player;
        }

        @Override
        protected void renderText(@NotNull PoseStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            RenderUtil.bindTexture(0, this.loadSkin());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int helmY = y + this.height / 2 - 12;
            RenderUtil.blit(stack, x, helmY, 24, 24, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.m_69478_();
            RenderUtil.blit(stack, x, helmY, 24, 24, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.m_69461_();
            RenderUtil.drawString(stack, this.text, x + 30, y + this.height / 2 - RenderUtil.getFontHeight() / 2, 0xFFFFFF);
        }

        @Override
        protected boolean isDefault() {
            return this.entry.isDefault() && this.muteEntry.isDefault();
        }

        @Override
        protected void onReset(@NotNull Button button) {
            this.entry.reset();
            this.muteEntry.reset();
            if (this.element instanceof UpdatableWidget) {
                ((UpdatableWidget)((Object)this.element)).updateValue();
            }
            if (this.resetAction != null) {
                this.resetAction.onReset(this.resetButton, this.element);
            }
        }

        private ResourceLocation loadSkin() {
            ModPlayerSkins.loadSkin(this.player);
            return ModPlayerSkins.getSkin(this.player.getId(), this.player.getName());
        }
    }
}

