/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.obscuria.obscureapi.client.screen.ObscuriaCollectionScreen;
import com.obscuria.obscureapi.network.ObscuriaCollection;
import com.obscuria.obscureapi.util.RenderUtils;
import com.obscuria.obscureapi.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class ModListScreen
extends ObscuriaCollectionScreen {
    private final List<AddonWidget> addons = new ArrayList<AddonWidget>();
    private ListWidget modListWidget;
    private ObscuriaCollection.Mod selectedMod;
    private Button config;
    private Button modPage;
    private Button update;
    private Button curseforge;

    public ModListScreen(Screen parent) {
        super(parent);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.PARENT);
        } else {
            super.m_7379_();
        }
    }

    @Override
    protected void m_7856_() {
        this.modListWidget = new ListWidget(this, 206, this.f_96544_ / 2 - 100, this.f_96544_ / 2 + 100);
        this.modListWidget.m_93507_(this.f_96543_ / 2 - 210);
        this.config = new Button(this.f_96543_ / 2 + 7, this.f_96544_ / 2 + 76, 95, 20, (Component)Component.m_237113_((String)"Settings"), button -> this.selectedMod.openConfig(this));
        this.modPage = new Button(this.f_96543_ / 2 + 107, this.f_96544_ / 2 + 76, 95, 20, (Component)Component.m_237113_((String)"Mod Page"), button -> Util.m_137581_().m_137646_(this.selectedMod.getLink()));
        this.update = new Button(this.f_96543_ / 2 + 107, this.f_96544_ / 2 + 76, 95, 20, (Component)Component.m_237113_((String)"Update"), button -> Util.m_137581_().m_137646_(this.selectedMod.getLink())){

            public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
                super.m_6303_(pose, mouseX, mouseY, partialTicks);
                RenderUtils.screen(new ResourceLocation("forge", "textures/gui/version_check_icons.png"), () -> 1.m_93133_((PoseStack)pose, (int)(this.f_93620_ + this.f_93618_ - 15), (int)(this.f_93621_ + 6), (float)24.0f, (float)((System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (int)64, (int)16));
            }
        };
        this.curseforge = new Button(this.f_96543_ / 2 + 7, this.f_96544_ / 2 + 76, 195, 20, (Component)Component.m_237113_((String)"View on Curseforge"), button -> Util.m_137581_().m_137646_(this.selectedMod.getLink()));
        this.addons.clear();
        for (int i = 0; i < 8; ++i) {
            this.addons.add(new AddonWidget(this, this.f_96543_ / 2 + 210, this.f_96544_ / 2 - 100 + 24 * i));
        }
        this.updateButtons();
        this.m_142416_((GuiEventListener)this.modListWidget);
        this.m_142416_((GuiEventListener)this.config);
        this.m_142416_((GuiEventListener)this.modPage);
        this.m_142416_((GuiEventListener)this.update);
        this.m_142416_((GuiEventListener)this.curseforge);
        this.addons.forEach(x$0 -> {
            AddonWidget cfr_ignored_0 = (AddonWidget)this.m_142416_((GuiEventListener)x$0);
        });
        ArrayList<ObscuriaCollection.Mod> entry = new ArrayList<ObscuriaCollection.Mod>();
        for (ObscuriaCollection.Mod mod2 : ObscuriaCollection.getSortedMods()) {
            entry.add(mod2);
            if (entry.size() < 3) continue;
            this.modListWidget.addEntry(List.copyOf(entry));
            entry.clear();
        }
        if (!entry.isEmpty()) {
            this.modListWidget.addEntry(List.copyOf(entry));
            entry.clear();
        }
        super.m_7856_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int i) {
        if (this.isTabClicked(mouseX, mouseY, i)) {
            return true;
        }
        Optional<AbstractWidget> widget = this.modListWidget.getMouseOver(mouseX, mouseY);
        return widget.map(abstractWidget -> abstractWidget.m_6375_(mouseX, mouseY, i)).orElseGet(() -> super.m_6375_(mouseX, mouseY, i));
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        if (ObscuriaCollection.isLoaded()) {
            RenderUtils.screenBlend(SHADER_TEXTURE, 0.5f, () -> ModListScreen.m_93133_((PoseStack)pose, (int)(this.f_96543_ / 2 + 4), (int)(this.f_96544_ / 2 - 100), (float)0.0f, (float)0.0f, (int)200, (int)200, (int)16, (int)16));
            if (this.selectedMod != null) {
                GuiComponent.m_93208_((PoseStack)pose, (Font)Minecraft.m_91087_().f_91062_, (String)(this.selectedMod.getName() + (String)(this.selectedMod.isInstalled() ? " \u00a78(" + ModList.get().getModFileById(this.selectedMod.getId()).versionString() + ")" : "")), (int)(this.f_96543_ / 2 + 104), (int)(this.f_96544_ / 2 - 90), (int)0xFFFFFF);
                ArrayList<Component> description = new ArrayList<Component>();
                int offset = 0;
                for (String line : this.selectedMod.getDescription()) {
                    TextUtils.buildTooltip(description, 30, line, "");
                }
                for (Component component : description) {
                    GuiComponent.m_93243_((PoseStack)pose, (Font)Minecraft.m_91087_().f_91062_, (Component)component, (int)(this.f_96543_ / 2 + 20), (int)(this.f_96544_ / 2 - 70 + offset), (int)0xFFFFFF);
                    offset += 11;
                }
            }
        } else {
            GuiComponent.m_93215_((PoseStack)pose, (Font)Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"Error loading data from server"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFF5555);
        }
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
    }

    private void updateButtons() {
        if (!ObscuriaCollection.isLoaded()) {
            this.config.f_93623_ = false;
            this.modPage.f_93623_ = false;
            this.curseforge.f_93623_ = false;
            this.update.f_93623_ = false;
            this.config.f_93624_ = false;
            this.modPage.f_93624_ = false;
            this.curseforge.f_93624_ = false;
            this.update.f_93624_ = false;
        } else if (this.selectedMod == null) {
            this.config.f_93623_ = false;
            this.modPage.f_93623_ = false;
            this.curseforge.f_93623_ = false;
            this.update.f_93623_ = false;
            this.config.f_93624_ = true;
            this.modPage.f_93624_ = true;
            this.curseforge.f_93624_ = false;
            this.update.f_93624_ = false;
        } else if (this.selectedMod.isInstalled()) {
            this.config.f_93623_ = this.selectedMod.hasConfig();
            this.modPage.f_93623_ = this.selectedMod.isLoaded() && !this.selectedMod.isOutdated();
            this.update.f_93623_ = this.selectedMod.isLoaded() && this.selectedMod.isOutdated();
            this.curseforge.f_93623_ = false;
            this.config.f_93624_ = true;
            this.modPage.f_93624_ = !this.selectedMod.isOutdated();
            this.update.f_93624_ = this.selectedMod.isOutdated();
            this.curseforge.f_93624_ = false;
        } else {
            this.config.f_93623_ = false;
            this.modPage.f_93623_ = false;
            this.update.f_93623_ = false;
            this.curseforge.f_93623_ = true;
            this.config.f_93624_ = false;
            this.modPage.f_93624_ = false;
            this.update.f_93624_ = false;
            this.curseforge.f_93624_ = true;
        }
        if (this.selectedMod == null || !this.selectedMod.isAddon()) {
            this.addons.forEach(addonWidget -> {
                addonWidget.MOD = null;
            });
            if (this.selectedMod != null && !this.selectedMod.getAddons().isEmpty()) {
                List<ObscuriaCollection.Mod> addons = this.selectedMod.getAddons();
                this.addons.get((int)0).MOD = this.selectedMod;
                for (int i = 1; i <= Math.min(8, addons.size()); ++i) {
                    this.addons.get((int)i).MOD = addons.get(i - 1);
                }
            }
            this.addons.forEach(addonWidget -> {
                if (addonWidget.MOD == null) {
                    addonWidget.f_93624_ = false;
                    addonWidget.f_93623_ = false;
                } else {
                    addonWidget.f_93624_ = true;
                    addonWidget.f_93623_ = true;
                }
            });
        }
    }

    public static class ListWidget
    extends ObjectSelectionList<Entry> {
        private final ModListScreen PARENT;
        private final int WIDTH;

        public ListWidget(ModListScreen parent, int width, int top, int bottom) {
            super(parent.getMinecraft(), width, parent.f_96544_, top, bottom, 82);
            this.PARENT = parent;
            this.WIDTH = width;
        }

        protected int m_5756_() {
            return this.getLeft() + this.WIDTH - 6;
        }

        public int m_5759_() {
            return this.WIDTH - 24;
        }

        public void addEntry(List<ObscuriaCollection.Mod> mods) {
            super.m_7085_((AbstractSelectionList.Entry)Entry.create(this.PARENT, mods));
        }

        public Optional<AbstractWidget> getMouseOver(double mouseX, double mouseY) {
            for (Entry entry : this.m_6702_()) {
                for (ModWidget modWidget : entry.MODS) {
                    if (!modWidget.m_5953_(mouseX, mouseY)) continue;
                    return Optional.of(modWidget);
                }
            }
            return Optional.empty();
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            if (ObscuriaCollection.isLoaded()) {
                super.m_6305_(pose, mouseX, mouseY, partialTicks);
            }
        }

        public static class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final List<ModWidget> MODS;

            private Entry(List<ModWidget> mods) {
                this.MODS = ImmutableList.copyOf(mods);
            }

            public static Entry create(ModListScreen parent, List<ObscuriaCollection.Mod> mods) {
                ArrayList<ModWidget> list = new ArrayList<ModWidget>();
                int offset = parent.modListWidget.getLeft() + 2;
                for (ObscuriaCollection.Mod mod2 : mods) {
                    list.add(new ModWidget(parent, offset, 0, mod2));
                    offset += 66;
                }
                return new Entry(list);
            }

            @Nonnull
            public Component m_142172_() {
                return Component.m_237119_();
            }

            public void m_6311_(PoseStack pose, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                this.MODS.forEach(modWidget -> {
                    modWidget.f_93621_ = top;
                    modWidget.m_6305_(pose, mouseX, mouseY, partialTick);
                });
            }
        }
    }

    public static class AddonWidget
    extends Button {
        @Nullable
        private ObscuriaCollection.Mod MOD;

        public AddonWidget(ModListScreen parent, int x, int y) {
            super(x, y, 20, 20, GameNarrator.f_93310_, button -> {
                if (button instanceof AddonWidget) {
                    AddonWidget addonWidget = (AddonWidget)button;
                    if (addonWidget.MOD != null) {
                        parent.selectedMod = addonWidget.MOD;
                        parent.updateButtons();
                    }
                }
            }, (button, pose, mouseX, mouseY) -> {
                if (button instanceof AddonWidget) {
                    AddonWidget addonWidget = (AddonWidget)button;
                    if (addonWidget.MOD != null) {
                        parent.m_96602_(pose, (Component)Component.m_237113_((String)addonWidget.MOD.getName()), mouseX, mouseY);
                    }
                }
            });
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            super.m_6303_(pose, mouseX, mouseY, partialTicks);
            if (this.MOD != null) {
                RenderUtils.screen(this.MOD.getIcon(), () -> AddonWidget.m_93133_((PoseStack)pose, (int)(this.f_93620_ + 2), (int)(this.f_93621_ + 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16));
            }
            if (this.m_198029_()) {
                this.f_93718_.m_93752_((Button)this, pose, mouseX, mouseY);
            }
        }

        public void m_7428_(PoseStack pose, int mouseX, int mouseY) {
        }
    }

    public static class ModWidget
    extends ImageButton {
        private final ObscuriaCollection.Mod MOD;

        public ModWidget(ModListScreen parent, int x, int y, ObscuriaCollection.Mod mod2) {
            super(x, y, 64, 80, 0, 0, new ResourceLocation("blank"), button -> {
                parent.selectedMod = mod2;
                parent.updateButtons();
            });
            this.MOD = mod2;
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            RenderUtils.screen(ObscuriaCollectionScreen.MOD_TEXTURE, () -> {
                ModWidget.m_93133_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (float)(this.m_198029_() ? 64.0f : 0.0f), (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)128, (int)80);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.MOD.getCover());
                ModWidget.m_93133_((PoseStack)pose, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (float)0.0f, (float)0.0f, (int)62, (int)62, (int)62, (int)62);
                pose.m_85836_();
                pose.m_85837_((double)(this.f_93620_ + 32), (double)(this.f_93621_ + 68), 0.0);
                pose.m_85841_(0.66666f, 0.66666f, 1.0f);
                GuiComponent.m_93208_((PoseStack)pose, (Font)Minecraft.m_91087_().f_91062_, (String)this.MOD.getName(), (int)0, (int)0, (int)0xFFFFFF);
                pose.m_85849_();
            });
            if (this.MOD.isOutdated()) {
                RenderUtils.screen(new ResourceLocation("forge", "textures/gui/version_check_icons.png"), () -> ModWidget.m_93133_((PoseStack)pose, (int)(this.f_93620_ + this.f_93618_ - 12), (int)(this.f_93621_ + 5), (float)24.0f, (float)((System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (int)64, (int)16));
            }
            if (!this.MOD.isInstalled()) {
                RenderUtils.screenBlend(ObscuriaCollectionScreen.SHADER_TEXTURE, 0.75f, () -> ModWidget.m_93133_((PoseStack)pose, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (float)0.0f, (float)0.0f, (int)(this.f_93618_ - 2), (int)(this.f_93619_ - 2), (int)16, (int)16));
            }
        }
    }
}

