/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi;

import com.obscuria.obscureapi.ObscureAPIClient;
import com.obscuria.obscureapi.ObscureAPIConfig;
import com.obscuria.obscureapi.api.ai.ITreeFlowAI;
import com.obscuria.obscureapi.api.common.DynamicProjectileItem;
import com.obscuria.obscureapi.api.hekate.Interpolations;
import com.obscuria.obscureapi.common.enchantments.DistanceEnchantment;
import com.obscuria.obscureapi.common.enchantments.FastSpinEnchantment;
import com.obscuria.obscureapi.common.enchantments.MirrorEnchantment;
import com.obscuria.obscureapi.event.ObscureAPIEnchantmentsEvent;
import com.obscuria.obscureapi.event.ObscureAPIHooks;
import com.obscuria.obscureapi.registry.ObscureAPIAttributes;
import com.obscuria.obscureapi.registry.ObscureAPIEntities;
import com.obscuria.obscureapi.registry.ObscureAPIItems;
import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import com.obscuria.obscureapi.registry.ObscureAPISounds;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="obscure_api")
public class ObscureAPI {
    public static final Logger LOGGER = LogManager.getLogger(ObscureAPI.class);
    public static final boolean DEBUG = false;
    public static final boolean REMAP = true;
    public static final String MODID = "obscure_api";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("obscure_api", "obscure_api"), () -> "1", "1"::equals, "1"::equals);
    public static final HashMap<String, String> COLLECTION_MODS = new HashMap();
    public static final EnchantmentCategory DYNAMIC_PROJECTILE_MIRROR = EnchantmentCategory.create((String)"dynamic_projectile_mirror", item -> item.getClass().isAnnotationPresent(DynamicProjectileItem.class) && item.getClass().getAnnotation(DynamicProjectileItem.class).mirror());
    public static final EnchantmentCategory DYNAMIC_PROJECTILE_FAST_SPIN = EnchantmentCategory.create((String)"dynamic_projectile_fast_spin", item -> item.getClass().isAnnotationPresent(DynamicProjectileItem.class) && item.getClass().getAnnotation(DynamicProjectileItem.class).fastSpin());
    public static final EnchantmentCategory DYNAMIC_PROJECTILE_DISTANCE = EnchantmentCategory.create((String)"dynamic_projectile_distance", item -> item.getClass().isAnnotationPresent(DynamicProjectileItem.class) && item.getClass().getAnnotation(DynamicProjectileItem.class).distance());
    private static int messageID = 0;

    public ObscureAPI() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ObscureAPIConfig.register();
        ObscureAPIItems.REGISTRY.register(modBus);
        ObscureAPIMobEffects.REGISTRY.register(modBus);
        ObscureAPIAttributes.REGISTRY.register(modBus);
        ObscureAPIEntities.REGISTRY.register(modBus);
        ObscureAPISounds.REGISTRY.register(modBus);
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::registerAttributes);
        modBus.addListener(this::registries);
        MinecraftForge.EVENT_BUS.addListener(this::entityTickHandler);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ObscureAPIAttributes::regenerationEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ObscureAPIAttributes::parryAndDodgeEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ObscureAPIAttributes::magicDamageEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ObscureAPIAttributes::healEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ObscureAPIAttributes::criticalHitAndMagicResistanceEvent);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, ObscureAPIClient.getConfigScreen());
        }
        Interpolations.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void registries(RegisterEvent event) {
        ObscureAPIHooks.registerClassesEvent();
        ObscureAPIEnchantmentsEvent enchantmentsEvent = ObscureAPIHooks.registerEnchantmentsEvent();
        if (enchantmentsEvent.getMirror()) {
            event.register(Registry.f_122902_, new ResourceLocation(MODID, "mirror"), () -> new MirrorEnchantment(new EquipmentSlot[0]));
        }
        if (enchantmentsEvent.getFastSpin()) {
            event.register(Registry.f_122902_, new ResourceLocation(MODID, "fast_spin"), () -> new FastSpinEnchantment(new EquipmentSlot[0]));
        }
        if (enchantmentsEvent.getDistance()) {
            event.register(Registry.f_122902_, new ResourceLocation(MODID, "distance"), () -> new DistanceEnchantment(new EquipmentSlot[0]));
        }
    }

    private void registerAttributes(@Nonnull EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            event.add(type, (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            event.add(type, (Attribute)ObscureAPIAttributes.CRITICAL_DAMAGE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.DODGE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.PARRY.get());
            event.add(type, (Attribute)ObscureAPIAttributes.ACCURACY.get());
            event.add(type, (Attribute)ObscureAPIAttributes.MAGIC_DAMAGE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.MAGIC_RESISTANCE.get());
            event.add(type, (Attribute)ObscureAPIAttributes.PENETRATION.get());
            event.add(type, (Attribute)ObscureAPIAttributes.REGENERATION.get());
            event.add(type, (Attribute)ObscureAPIAttributes.HEALING_POWER.get());
            event.add(type, (Attribute)ObscureAPIAttributes.RESILIENCE.get());
        }
    }

    private void entityTickHandler(@Nonnull LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ITreeFlowAI) {
            ITreeFlowAI ITreeFlowAI2 = (ITreeFlowAI)livingEntity;
            ITreeFlowAI2.getAIHandler().tick();
        }
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }
}

