/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math.colors;

import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.ColorSpaces;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.util.Mth;
import oshi.annotation.concurrent.Immutable;

@Immutable
public class LUVColor
extends BaseColor<LUVColor> {
    public LUVColor(float l, float u, float v, float alpha) {
        super(l, u, v, alpha);
    }

    public String toString() {
        return String.format("L: %s, U: %s, V %s", (int)(255.0f * this.luminance()), (int)(255.0f * this.u()), (int)(255.0f * this.v()));
    }

    public float luminance() {
        return this.v0;
    }

    public float u() {
        return this.v1;
    }

    public float v() {
        return this.v2;
    }

    public float alpha() {
        return this.v3;
    }

    public LUVColor withLuminance(float luminance) {
        return new LUVColor(luminance, this.u(), this.v(), this.alpha());
    }

    public LUVColor withU(float u) {
        return new LUVColor(this.luminance(), u, this.v(), this.alpha());
    }

    public LUVColor withV(float v) {
        return new LUVColor(this.luminance(), this.u(), v, this.alpha());
    }

    public LUVColor withAlpha(float alpha) {
        return new LUVColor(this.luminance(), this.u(), this.v(), alpha);
    }

    public static LUVColor averageColors(LUVColor ... colors) {
        float size = colors.length;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        for (LUVColor c : colors) {
            r += c.luminance();
            g += c.u();
            b += c.v();
            a += c.alpha();
        }
        return new LUVColor(r / size, g / size, b / size, a / size);
    }

    @Override
    public LUVColor asLUV() {
        return this;
    }

    @Override
    public RGBColor asRGB() {
        return ColorSpaces.XYZtoRGB(ColorSpaces.LUVtoXYZ(this));
    }

    @Override
    public LUVColor multiply(LUVColor color, float luminance, float u, float v, float alpha) {
        return new LUVColor(Mth.m_14036_((float)(luminance * this.luminance()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(u * this.u()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(v * this.v()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(alpha * this.alpha()), (float)0.0f, (float)1.0f));
    }

    @Override
    public LUVColor mixWith(LUVColor color, float bias) {
        float i = 1.0f - bias;
        float r = this.luminance() * i + color.luminance() * bias;
        float g = this.u() * i + color.u() * bias;
        float b = this.v() * i + color.v() * bias;
        float a = this.alpha() * i + color.alpha() * bias;
        return new LUVColor(r, g, b, a);
    }

    @Override
    public LUVColor fromRGB(RGBColor rgb) {
        return rgb.asLUV();
    }
}

