/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.fake_player;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.util.fake_player.ClientAccess;
import net.mehvahdjukaar.moonlight.api.util.fake_player.FakeServerPlayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.ApiStatus;

public class FakePlayerManager {
    private static final GameProfile DEFAULT = new GameProfile(UUID.fromString("61e22C44-14d5-1f22-ed27-13D2C95CA355"), "[ML_Fake_Player]");

    public static Player get(GameProfile id, Entity entity) {
        return FakePlayerManager.get(id, entity.f_19853_);
    }

    public static Player get(GameProfile id, Level level) {
        Object fakePlayer;
        try {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                fakePlayer = FakeServerPlayer.get(sl, id);
            } else {
                fakePlayer = ClientAccess.get(level, id);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Level must be either ServerLevel or ClientLevel", e);
        }
        return fakePlayer;
    }

    public static Player get(GameProfile id, Entity copyPosFrom, Entity copyRotFrom) {
        Player p = FakePlayerManager.get(id, copyPosFrom.f_19853_);
        p.m_6034_(copyPosFrom.m_20185_(), copyPosFrom.m_20186_(), copyPosFrom.m_20189_());
        p.m_5616_(copyRotFrom.m_6080_());
        p.m_146926_(copyRotFrom.m_146909_());
        p.m_146922_(copyRotFrom.m_146908_());
        p.m_146867_();
        return p;
    }

    @Deprecated(forRemoval=true)
    public static Player get(Entity copyPosFrom, Entity copyRotFrom) {
        return FakePlayerManager.getDefault(copyPosFrom, copyRotFrom);
    }

    public static Player getDefault(Entity copyPosFrom, Entity copyRotFrom) {
        return FakePlayerManager.get(DEFAULT, copyPosFrom, copyRotFrom);
    }

    public static Player getDefault(Level level) {
        return FakePlayerManager.get(DEFAULT, level);
    }

    public static Player getDefault(Entity entity) {
        return FakePlayerManager.get(DEFAULT, entity);
    }

    @ApiStatus.Internal
    public static void unloadLevel(LevelAccessor level) {
        try {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                FakeServerPlayer.unloadLevel((Level)sl);
            } else if (level.m_5776_()) {
                ClientAccess.unloadLevel(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

