/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.registery;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;

public class SpawnSettings {
    private static final Language language = Language.m_128107_();

    public static void initSpawnSettings(Entities.EntityKey mountKey, EntityType<MountEntity> type, boolean printLines) {
        Settings.EntitySettings settings = Settings.settings.get((Object)mountKey);
        if (settings.shouldSpawn) {
            Heightmap.Types motionBlocking = Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
            MobCategory spawnGroup = MobCategory.CREATURE;
            SpawnPlacements.Type spawnRestrictionLoc = SpawnPlacements.Type.NO_RESTRICTIONS;
            if ("overworld".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = SpawnPlacements.Type.ON_GROUND;
            } else if ("village".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                spawnRestrictionLoc = SpawnPlacements.Type.ON_GROUND;
                spawnGroup = MobCategory.AMBIENT;
            } else if (!"water".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                if ("nether".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                    spawnRestrictionLoc = SpawnPlacements.Type.ON_GROUND;
                    spawnGroup = MobCategory.MONSTER;
                } else if ("end".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                    spawnRestrictionLoc = SpawnPlacements.Type.ON_GROUND;
                } else if ("subterranean".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                    spawnRestrictionLoc = SpawnPlacements.Type.ON_GROUND;
                    spawnGroup = MobCategory.MONSTER;
                } else {
                    spawnRestrictionLoc = SpawnPlacements.Type.NO_RESTRICTIONS;
                }
            }
            SpawnConditions spawnConditions = new SpawnConditions(mountKey, type, (double)(100 - settings.spawnRandomChance) / 100.0);
            SpawnPlacements.SpawnPredicate spawnPredicate = spawnConditions::doBlockChecks;
            SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)spawnRestrictionLoc, (Heightmap.Types)motionBlocking, (SpawnPlacements.SpawnPredicate)spawnPredicate);
        }
    }

    public static String translate(String key, Object ... args) {
        String string = language.m_6834_(key);
        try {
            return String.format(string, args);
        }
        catch (IllegalFormatException var4) {
            return "Format error: " + string;
        }
    }

    public static class SpawnConditions {
        double rarity;
        int yCeil;
        int yFloor;
        boolean debug;
        Block[] blocks;
        Entities.EntityKey mountKey;

        public SpawnConditions(Entities.EntityKey mountKey, EntityType<? extends MountEntity> type, double rarity) {
            this.mountKey = mountKey;
            this.rarity = rarity;
            this.yCeil = Settings.settings.get((Object)((Object)mountKey)).spawnYCeiling;
            this.yFloor = Settings.settings.get((Object)((Object)mountKey)).spawnYFloor;
            this.initBlocks(Settings.settings.get((Object)((Object)mountKey)).spawnBlocks);
            this.debug = Settings.settings.get((Object)((Object)mountKey)).spawnDebug || Settings.globalSettings.debug;
        }

        public void initBlocks(String[] blockNames) {
            if (blockNames.length > 0 && "all".equals(blockNames[0].trim().toLowerCase(Locale.ROOT))) {
                this.blocks = null;
                return;
            }
            this.blocks = new Block[blockNames.length];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = (Block)Registry.f_122824_.m_7745_(ResourceLocation.m_135820_((String)blockNames[i]));
            }
        }

        public boolean isValidChunk(int freq, int offset, Vec2 chunkPos) {
            if (freq < 0) {
                return false;
            }
            if (freq == 0 || freq == 1) {
                return true;
            }
            if (freq == 2) {
                if (offset % 2 == 0) {
                    return chunkPos.f_82470_ % 2.0f == chunkPos.f_82471_ % 2.0f;
                }
                return chunkPos.f_82470_ % 2.0f != chunkPos.f_82471_ % 2.0f;
            }
            return (chunkPos.f_82470_ + (float)offset) % (float)(freq - 1) == 0.0f && (chunkPos.f_82471_ + (float)offset) % (float)(freq - 1) == 0.0f;
        }

        public static String getBiomeId(Holder<Biome> biomeHolder) {
            return (String)biomeHolder.m_203439_().map(key -> key.m_135782_().toString(), key -> "[unregistered " + key + "]");
        }

        boolean doBlockChecks(EntityType<? extends MountEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
            BlockState[] check;
            List nearbyMounts;
            Settings.EntitySettings settings = Settings.settings.get((Object)this.mountKey);
            Vec2 chunkPos = new Vec2((float)(world.m_46865_((BlockPos)pos).m_7697_().f_45578_ + settings.chunkOffset), (float)(world.m_46865_((BlockPos)pos).m_7697_().f_45579_ + settings.chunkOffset));
            String currentBiomeId = SpawnConditions.getBiomeId((Holder<Biome>)world.m_204166_(pos));
            int foundBiome = Arrays.binarySearch(settings.spawnBiomes, currentBiomeId);
            if (foundBiome < -1) {
                this.printDebug(type, "Failed biome restrictions. (Attempted to spawn in " + currentBiomeId + ")");
                return false;
            }
            if (!this.isValidChunk(settings.chunkFreq, settings.chunkOffset, chunkPos)) {
                this.printDebug(type, "Failed chunk restrictions " + settings.chunkFreq + " " + settings.chunkOffset + " " + chunkPos.f_82470_ + " " + chunkPos.f_82471_);
                return false;
            }
            double rareness = random.m_188500_();
            if (rareness < this.rarity) {
                this.printDebug(type, "Failed random chance to spawn " + rareness + " " + this.rarity);
                return false;
            }
            if (pos.m_123342_() < this.yFloor || pos.m_123342_() > this.yCeil) {
                this.printDebug(type, "Failed floor/ceiling checks");
                return false;
            }
            if (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49991_) || world.m_8055_(pos).m_60713_(Blocks.f_49991_) || world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49991_)) {
                this.printDebug(type, "Failed to spawn since there was lava");
                return false;
            }
            if ("overworld".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                BlockPos topBlock = new BlockPos((double)pos.m_123341_(), (double)((float)world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_() - 1.0f), (double)pos.m_123343_());
                if (!world.m_45527_(pos) && pos.m_123342_() < world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_() && !world.m_8055_(topBlock).m_204336_(BlockTags.f_13035_)) {
                    this.printDebug(type, "Failed to spawn since it is an overworld entity and was in a cave");
                    return false;
                }
            }
            if ("subterranean".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                if ((pos.m_123342_() >= world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_() - 20 || world.m_45527_(pos)) && pos.m_123342_() >= world.m_5736_() - 15) {
                    this.printDebug(type, "Failed to spawn since it is a subterranean entity and tried to spawn above ground");
                    return false;
                }
                int unloadDist = 96;
                if (!world.isAreaLoaded(pos, unloadDist)) {
                    this.printDebug(type, "Failed to spawn since it was too close to an unloaded chunk (can't accurately perform limit checks). ");
                    return false;
                }
            }
            if ("village".equals(settings.spawnType.toLowerCase(Locale.ROOT))) {
                this.printDebug(type, "trying village check");
                if (!world.m_5776_()) {
                    ServerLevelAccessor sla = (ServerLevelAccessor)world;
                    Predicate<Holder> villagePoiPredicate = poi -> poi.m_203656_(PoiTypeTags.f_215876_);
                    Optional searchRes = sla.m_6018_().m_8904_().m_218002_(villagePoiPredicate, pos, 8, PoiManager.Occupancy.ANY);
                    if (!searchRes.isPresent()) {
                        this.printDebug(type, "Failed to spawn since it is an was not near a village");
                        return false;
                    }
                }
            }
            if (Settings.globalSettings.mobCap > 0 && (nearbyMounts = world.m_45976_(MountEntity.class, new AABB(pos).m_82400_((double)Settings.globalSettings.mobCapRange))).size() >= Settings.globalSettings.mobCap / 2) {
                this.printDebug(type, "Failed to spawn since the global mob cap/limit for MythicMounts was reached.");
                return false;
            }
            if (settings.maxIn256Region > 0) {
                AABB searchSpace = new AABB(pos);
                List nearbyMounts2 = world.m_45976_(Entities.EntityInfo.getByKey((Entities.EntityKey)this.mountKey).entityClass, searchSpace = searchSpace.m_82400_(128.0));
                if (nearbyMounts2.size() >= settings.maxIn256Region) {
                    this.printDebug(type, "Failed to spawn since there are already the max number of this mob in the region nearby");
                    return false;
                }
            }
            if ("water".equals(settings.spawnType.toLowerCase(Locale.ROOT)) && !world.m_8055_(pos).m_60713_(Blocks.f_49990_) && !world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_) && !world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_)) {
                this.printDebug(type, "Failed to spawn since is a water entity and was not in water");
                return false;
            }
            if (!"water".equals(settings.spawnType.toLowerCase(Locale.ROOT)) && (world.m_8055_(pos).m_60713_(Blocks.f_49990_) || world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_) || world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_))) {
                this.printDebug(type, "Failed to spawn since is not a water entity and was in water");
                return false;
            }
            nearbyMounts = world.m_45976_(MountEntity.class, new AABB(pos).m_82400_(8.0));
            if (nearbyMounts.size() > 2) {
                this.printDebug(type, "Failed to spawn since there is already mythicmounts nearby " + nearbyMounts.size());
                return false;
            }
            if (this.blocks == null || this.blocks.length == 0) {
                this.printDebug(type, "Spawn conditions met. (It is possible, but not guaranteed, to spawn)");
                return true;
            }
            for (BlockState b : check = new BlockState[]{world.m_8055_(pos.m_7495_()), world.m_8055_(world.m_46805_(pos.m_122030_(3)) ? pos.m_122030_(3) : pos), world.m_8055_(world.m_46805_(pos.m_122030_(2)) ? pos.m_122030_(2) : pos), world.m_8055_(world.m_46805_(pos.m_122030_(1)) ? pos.m_122030_(1) : pos), world.m_8055_(world.m_46805_(pos.m_122025_(3)) ? pos.m_122025_(3) : pos), world.m_8055_(world.m_46805_(pos.m_122025_(2)) ? pos.m_122025_(2) : pos), world.m_8055_(world.m_46805_(pos.m_122025_(1)) ? pos.m_122025_(1) : pos), world.m_8055_(world.m_46805_(pos.m_122013_(3)) ? pos.m_122013_(3) : pos), world.m_8055_(world.m_46805_(pos.m_122013_(2)) ? pos.m_122013_(2) : pos), world.m_8055_(world.m_46805_(pos.m_122013_(1)) ? pos.m_122013_(1) : pos), world.m_8055_(world.m_46805_(pos.m_122020_(3)) ? pos.m_122020_(3) : pos), world.m_8055_(world.m_46805_(pos.m_122020_(2)) ? pos.m_122020_(2) : pos), world.m_8055_(world.m_46805_(pos.m_122020_(1)) ? pos.m_122020_(1) : pos)}) {
                int i = 1;
                while (b.m_60713_(Blocks.f_49990_) || !b.m_60767_().m_76333_()) {
                    b = world.m_8055_(pos.m_6625_(i));
                    ++i;
                }
                for (Block block : this.blocks) {
                    if (!b.m_60713_(block)) continue;
                    this.printDebug(type, "Spawn conditions met. (It is possible, but not guaranteed to spawn)");
                    return true;
                }
            }
            this.printDebug(type, "Failed block restrictions");
            return false;
        }

        public void printDebug(EntityType<? extends MountEntity> type, String message) {
            if (this.debug) {
                System.out.println(type.m_20676_().getString() + ": " + message);
            }
        }
    }
}

