/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.mounts;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.SwimmingMountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.builder.AnimationBuilder;

public class NudibranchEntity
extends SwimmingMountEntity {
    final String[] idleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle4", "animation.mount.idle5"};
    private final int healInterval = 20;
    private int healCounter = 0;

    public NudibranchEntity(EntityType<? extends MountEntity> type, Level worldIn) {
        super(type, worldIn, Entities.EntityKey.NUDIBRANCH);
        this.armorTextureBaseStr = "textures/model/entity/armor/nudibranch_armor";
        this.textures.add("nudibranch_mount.png");
        this.textures.add("nudibranch_mount2.png");
        this.textures.add("nudibranch_mount3.png");
        this.textures.add("nudibranch_mount4.png");
        this.textures.add("nudibranch_mount5.png");
        this.leashYOffset = 1.0f;
        this.leashZOffset = 0.4f;
        this.miniYOffset = 0.55f;
    }

    @Override
    public String getDefaultTexture() {
        return "nudibranch_mount.png";
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.m_5912_()) {
            return (SoundEvent)Sounds.NUDIBRANCH_ANGRY_EVENT.get();
        }
        return (SoundEvent)Sounds.NUDIBRANCH_AMBIENT_EVENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)Sounds.NUDIBRANCH_HURT_EVENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)Sounds.NUDIBRANCH_DEATH_EVENT.get();
    }

    @Override
    protected SoundEvent m_7871_() {
        return (SoundEvent)Sounds.NUDIBRANCH_ANGRY_EVENT.get();
    }

    @Override
    public AnimationBuilder getIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public AnimationBuilder getSleepingIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.settings.specialAbilitiesEnabled) {
            ++this.healCounter;
            if (!this.f_19853_.f_46443_ && this.m_217005_()) {
                for (Entity e : this.m_20197_()) {
                    LivingEntity entity = null;
                    if (e instanceof LivingEntity) {
                        entity = (LivingEntity)e;
                    }
                    if (!(entity.m_21223_() < entity.m_21233_()) || this.healCounter % 20 != 0) continue;
                    entity.m_21153_(Math.min(entity.m_21223_() + 0.5f, entity.m_21233_()));
                }
            }
            if (this.healCounter % 20 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(Math.min(this.m_21223_() + 0.5f, this.m_21233_()));
            }
            this.healCounter %= 20;
        }
    }

    @Override
    protected float m_6121_() {
        return 0.5f * this.soundVolume;
    }
}

