/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.FlyingMountMoveControl;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountGoals;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FlyingMountEntity
extends MountEntity {
    boolean takingOff = false;
    boolean landing = false;
    int takeOffDelay = 0;
    int minFlyingDuration = 200 + this.f_19796_.m_188503_(2000);
    int flyingCounter = 0;
    int maxGroundDuration = 200 + this.f_19796_.m_188503_(2000);
    int groundCounter = 0;
    int perspective = -1;
    boolean checkFallDamageing = false;
    double yInit = 0.0;

    public FlyingMountEntity(EntityType<? extends Horse> type, Level levelIn, Entities.EntityKey mountKey) {
        super(type, levelIn, mountKey);
        this.canFly = true;
        this.f_21342_ = new FlyingMountMoveControl(this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean isBeingRidden = this.isBeingRidden();
        if (!isBeingRidden && this.m_27593_()) {
            this.setFlyingParams(false);
        }
        if (isBeingRidden && this.f_19861_) {
            this.setFlyingParams(false);
        }
        if (isBeingRidden && !this.f_19861_ && !this.getIsFlying() && !this.checkFallDamageing) {
            this.checkFallDamageing = true;
            this.yInit = this.m_20097_().m_123342_();
        }
        if (isBeingRidden && !this.f_19861_ && !this.getIsFlying() && this.checkFallDamageing && Math.abs((double)this.m_20097_().m_123342_() - this.yInit) > 2.0) {
            this.checkFallDamageing = false;
            this.setFlyingParams(true);
        }
        if (this.f_19853_.f_46443_ && !isBeingRidden) {
            this.setFlyingParams(this.getIsFlying());
        }
        if (Settings.globalSettings.enable3rdPersonFlying) {
            if (this.f_19853_.f_46443_ && isBeingRidden && this.perspective < 0) {
                this.perspective = Minecraft.m_91087_().f_91066_.m_92176_().ordinal();
                Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            }
            if (this.f_19853_.f_46443_ && !isBeingRidden && this.perspective >= 0) {
                if (Minecraft.m_91087_().f_91066_.m_92176_().equals((Object)CameraType.THIRD_PERSON_BACK)) {
                    Minecraft.m_91087_().f_91066_.m_92157_(CameraType.values()[this.perspective]);
                }
                this.perspective = -1;
            }
        }
        if (!this.f_19853_.f_46443_ && !this.m_217005_()) {
            if (!(this.getOwnerToldToSit() || this.getIsSitting() || this.m_6162_())) {
                this.updateTakeOff();
                this.updateLanding();
                if (this.getIsFlying()) {
                    ++this.flyingCounter;
                    if (!this.landing && !this.takingOff && this.flyingCounter >= this.minFlyingDuration) {
                        this.initLanding();
                    }
                } else {
                    ++this.groundCounter;
                    this.takingOff = false;
                    this.landing = false;
                    if (this.groundCounter >= this.maxGroundDuration && this.enoughRoomToTakeOff() && !this.m_21523_() && !this.m_217005_() && !this.getShouldFollow()) {
                        this.initTakeOff();
                    }
                }
            }
            this.updateAnimationState();
        } else if (!this.f_19853_.f_46443_ && this.m_217005_()) {
            this.resetWanderBehaviorCycle();
            this.setIsSitting(false);
            this.setIsSleeping(false);
        }
    }

    public void initTakeOff() {
        this.takingOff = true;
        this.takeOffDelay = 0;
        this.flyingCounter = 0;
        this.groundCounter = 0;
        this.setFlyingParams(true);
        if (!this.m_30614_()) {
            this.setTrackedPos(this.m_20097_().m_123341_(), this.m_20097_().m_123342_(), this.m_20097_().m_123343_());
        }
        this.maxGroundDuration = 200 + this.f_19796_.m_188503_(2000);
    }

    public void updateTakeOff() {
        if (this.takingOff) {
            ++this.takeOffDelay;
            if (!this.f_19861_ && this.takeOffDelay > 25) {
                this.takingOff = false;
                this.takeOffDelay = 0;
            }
        }
    }

    public boolean enoughRoomToTakeOff() {
        return this.f_19853_.m_45772_(this.m_20191_().m_82400_(1.0).m_82386_(0.0, 4.0, 0.0));
    }

    public void initLanding() {
        this.landing = true;
        this.minFlyingDuration = 200 + this.f_19796_.m_188503_(1000);
    }

    public void updateLanding() {
        if (this.landing) {
            boolean nearGround = false;
            for (int i = 0; i < 3; ++i) {
                if (!this.m_9236_().m_8055_(this.m_20097_().m_6625_(i)).m_60815_()) continue;
                nearGround = true;
            }
            if (!this.takingOff && !this.isBeingRidden() && (this.f_19861_ || nearGround) && this.getIsFlying()) {
                this.setFlyingParams(false);
                this.flyingCounter = 0;
                this.groundCounter = 0;
            }
        }
    }

    @Override
    public void onMounted() {
        super.onMounted();
        if (!this.f_19853_.f_46443_) {
            this.setFlyingParams(this.getIsFlying());
        }
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_6147_() {
        return false;
    }

    public void applySlowFallEffect(boolean shouldSlowFall) {
        if (shouldSlowFall) {
            MobEffectInstance s = new MobEffectInstance(MobEffects.f_19591_);
            this.m_147207_(s, null);
        } else {
            this.m_21195_(MobEffects.f_19591_);
        }
    }

    public float getWanderFlyingSpeed() {
        return 1.0f;
    }

    public void setFlyingParams(boolean isFlying) {
        this.setIsFlying(isFlying);
        this.m_30655_(isFlying);
        if (!Settings.globalSettings.disableGravity) {
            this.applySlowFallEffect(isFlying);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20242_(Settings.globalSettings.disableGravity && isFlying || isFlying && !this.m_217005_());
        }
        if (isFlying) {
            this.setIsSitting(false);
            this.setIsSleeping(false);
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 4.0f);
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
        }
    }

    @Override
    public void m_7023_(Vec3 movementInput) {
        boolean isBeingRidden;
        if (this.getIsSitting()) {
            super.m_7023_(Vec3.f_82478_);
        }
        if (isBeingRidden = this.isBeingRidden()) {
            if (!this.f_19853_.f_46443_ && !Settings.globalSettings.mountedFlightAllowed) {
                this.m_20242_(false);
                super.m_7023_(movementInput);
                return;
            }
            LivingEntity passengerEntity = this.m_6688_();
            this.m_146922_(passengerEntity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(passengerEntity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float passengerSidewaysSpeed = passengerEntity.f_20900_ * 0.5f;
            float passengerForwardSpeed = passengerEntity.f_20902_;
            if (passengerForwardSpeed <= 0.0f) {
                passengerForwardSpeed *= 0.25f;
                this.f_30524_ = 0;
            }
            double maxFlightSpeed = (double)this.m_6113_() * this.m_218811_(this.f_19796_) * 200.0;
            double upwardsVelocity = 0.3;
            if (this.f_30519_ && !this.getIsFlying() || this.f_30522_ > 0.0f) {
                Vec3 velocity = this.m_20184_();
                if (!this.m_20096_()) {
                    velocity = movementInput.m_82541_().m_82542_(1.0, maxFlightSpeed, 1.0);
                    upwardsVelocity = 1.0;
                    if (!this.getIsFlying()) {
                        this.setFlyingParams(true);
                    }
                } else {
                    upwardsVelocity = (double)this.m_6118_() * (double)this.f_30522_ * this.m_182332_();
                    if (this.m_21023_(MobEffects.f_19603_)) {
                        upwardsVelocity += (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f);
                    }
                }
                this.m_20334_(velocity.f_82479_, upwardsVelocity, velocity.f_82481_);
                this.m_30655_(true);
                this.f_19812_ = true;
                if (passengerForwardSpeed > 0.0f) {
                    float i = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    float j = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * i * this.f_30522_), 0.0, (double)(0.4f * j * this.f_30522_)));
                }
                this.f_30522_ = 0.0f;
            }
            if (this.m_6109_()) {
                if (this.m_20069_()) {
                    this.m_19920_(0.02f, movementInput);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82542_(1.0, (double)0.8f, 1.0));
                } else if (this.m_20077_()) {
                    this.m_19920_(0.02f, movementInput);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
                }
                if (this.getIsFlying()) {
                    if (!this.m_21023_(MobEffects.f_19591_)) {
                        this.applySlowFallEffect(true);
                    }
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 4.0f);
                    double upDown = 0.0;
                    if (passengerEntity.m_146909_() < 25.0f && passengerEntity.m_146909_() > -25.0f && passengerForwardSpeed != 0.0f) {
                        upDown = 0.225f;
                    } else if (passengerEntity.m_146909_() < -20.0f) {
                        upDown = (double)(passengerEntity.m_146909_() / 90.0f) * -maxFlightSpeed * (double)passengerForwardSpeed;
                        if (passengerEntity.m_146909_() < -40.0f) {
                            passengerForwardSpeed = 0.1f * passengerForwardSpeed;
                        }
                    } else if (passengerEntity.m_146909_() > 45.0f) {
                        upDown = 0.05 * -maxFlightSpeed * (double)passengerForwardSpeed;
                        passengerForwardSpeed = 0.1f * passengerForwardSpeed;
                    }
                    Vec3 flightVector = new Vec3((double)passengerSidewaysSpeed, upDown, (double)passengerForwardSpeed);
                    super.m_7023_(flightVector);
                } else {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)passengerSidewaysSpeed, movementInput.f_82480_, (double)passengerForwardSpeed));
                }
            } else if (passengerEntity instanceof Player) {
                this.m_20256_(Vec3.f_82478_);
            }
            if (!this.m_30616_() && this.getIsFlying()) {
                this.setFlyingParams(false);
            }
        }
        if (!this.f_19853_.m_5776_() && !isBeingRidden) {
            if (this.getIsFlying()) {
                this.flyingTravel(movementInput);
            } else {
                super.m_7023_(movementInput);
            }
        }
        this.m_21043_((LivingEntity)this, false);
    }

    public void flyingTravel(Vec3 movementInput) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, (double)0.8f, 1.0));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
        } else {
            float f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_())).m_60734_().m_49958_() * 0.91f;
            }
            float g = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_())).m_60734_().m_49958_() * 0.91f;
            }
            this.m_19920_(0.1f * g, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, (double)f, 1.0));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(7, (Goal)new MountGoals.FlyRandomlyGoal(this));
    }
}

