/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.yahoo.chirpycricket.mythicmounts.MythicMounts;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigFileHelper {
    public static final String configFileName = "MythicMountsConfig.json";

    protected static BufferedReader readOrCreateSettingsFile() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(FMLPaths.CONFIGDIR.get() + File.separator + configFileName));
            return br;
        }
        catch (FileNotFoundException e) {
            try {
                System.out.println("Created config file for mythicmounts mod.");
                ConfigFileHelper.createDefaultSettings();
                try {
                    br = new BufferedReader(new FileReader(FMLPaths.CONFIGDIR.get() + File.separator + configFileName));
                    return br;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return br;
        }
    }

    protected static void createDefaultSettings() throws IOException {
        FileWriter myWriter = new FileWriter(FMLPaths.CONFIGDIR.get() + File.separator + configFileName);
        myWriter.write("{\r\n    \"globalSettings\": {\r\n        \"configVersion\": 11,\r\n        \"configType\": \"Forge\",\r\n        \"printBiomes\": false,\r\n        \"globalDebug\": false,\r\n        \"enable3rdPersonFlying\": false,\r\n        \"enableFlyingGravity\": true,\r\n        \"mountFriendlyFireProtection\": false,\r\n        \"disableUiOverlay\": false,\r\n        \"mobCap\": 16,\r\n        \"mobCapRange\": 192\r\n    },\r\n    \"itemGroups\": {\r\n        \"flowerItems\": [\"sugar\", \"dandelion\", \"poppy\", \"blue_orchid\", \"allium\", \"azure_bluet\", \"red_tulip\", \"orange_tulip\", \"white_tulip\", \"pink_tulip\", \"oxeye_daisy\", \"cornflower\", \"lily_of_the_valley\", \"lilac\", \"rose_bush\", \"peony\", \"flowering_azalea_leaves\"],\r\n        \"grassItems\": [\"hay\", \"grass\", \"fern\", \"tall_grass\", \"large_fern\", \"bamboo\"],\r\n        \"leafItems\": [\"oak_leaves\", \"spruce_leaves\", \"birch_leaves\", \"jungle_leaves\", \"acacia_leaves\", \"dark_oak_leaves\", \"azalea_leaves\", \"flowering_azalea_leaves\", \"lily_pad\", \"small_dripleaf\", \"big_dripleaf\"],\r\n        \"mushroomItems\": [\"brown_mushroom\", \"red_mushroom\", \"crimson_fungus\", \"warped_fungus\"],\r\n        \"rootItems\": [\"cave_vines\", \"vines\", \"hanging_roots\", \"glow_lichen\", \"crimson_roots\", \"warped_roots\", \"nether_wart\", \"cactus\"],\r\n        \"seedItems\": [\"wheat_seeds\", \"melon_seeds\", \"pumpkin_seeds\", \"beetroot_seeds\", \"sweet_berries\"],\r\n        \"vegetableItems\": [\"potato\", \"carrot\", \"beetroot\"],\r\n        \"fruitItems\": [\"sweet_berries\", \"melon_slice\", \"apple\", \"glow_berries\"],\r\n        \"seaweedItems\": [\"seagrass\", \"kelp\", \"tall_seagrass\"],\r\n        \"fishItems\": [\"salmon\", \"cod\", \"tropical_fish\", \"pufferfish\"],\r\n        \"meatItems\": [\"rabbit\", \"chicken\", \"mutton\", \"beef\", \"porkchop\", \"egg\"],\r\n        \"scavengerItems\": [\"egg\", \"rotten_flesh\", \"spider_eye\"]\r\n    },\r\n    \"itemGroupCategories\": {\r\n        \"nectar\": [\"flowerItems\", \"fruitItems\"],\r\n        \"leafyHerbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\"],\r\n        \"heartyHerbivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"herbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"omnivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\", \"meatItems\", \"scavengerItems\"],\r\n        \"carnivore\": [\"meatItems\", \"fishItems\"],\r\n        \"scavenger\": [\"scavengerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"],\r\n        \"piscivore\": [\"seaweedItems\", \"fishItems\"],\r\n        \"oceanScavenger\": [\"seaweedItems\", \"scavengerItems\", \"fishItems\", \"vegetableItems\"]\r\n    },\r\n    \"spawnCategories\": {\r\n        \"CourierBirdSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"DireWolfSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"DragonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"subterranean\",\r\n            \"maxIn256Region\": 1\r\n        },\r\n        \"GriffonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 100,\r\n            \"spawnRandomChance\": 70,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"GeckotoaSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 60,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 3,\r\n            \"chunkOffset\": 1,\r\n            \"spawnType\": \"subterranean\",\r\n            \"maxIn256Region\": 2\r\n        },\r\n        \"MothSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 70,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"ColelytraSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"NetherBatSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 1,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"nether\",\r\n            \"maxIn256Region\": 6\r\n        },\r\n        \"NudibranchSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"water\"\r\n        },\r\n        \"RidingLizardSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnWeight\": 10,\r\n            \"spawnRandomChance\": 50,\r\n            \"chunkFreq\": 5,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"NightmareSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 1,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"nether\",\r\n            \"maxIn256Region\": 6\r\n        },\r\n        \"AcenciaSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"overworld\"\r\n        },\r\n        \"ArchelonSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"water\",\r\n            \"maxIn256Region\": 2\r\n        },\r\n       \"FirebirdSpawnSettings\": {\r\n            \"shouldSpawn\": true,\r\n            \"spawnDebug\": false,\r\n            \"spawnRandomChance\": 100,\r\n            \"spawnYCeiling\": 50000,\r\n            \"spawnYFloor\": 60,\r\n            \"chunkFreq\": 0,\r\n            \"chunkOffset\": 0,\r\n            \"spawnType\": \"village\",\r\n            \"maxIn256Region\": 1\r\n        }\r\n    },\r\n    \"mobConfig\": {\r\n        \"ACENCIA\": {\r\n            \"health\": 28,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 10,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"AcenciaSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"mutton\",\"salmon\"],\r\n            \"breedingItems\": [\"rabbit\", \"chicken\", \"mutton\", \"salmon\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:rabbit\",\"minecraft:sheep\",\"minecraft:goat\",\"minecraft:chicken\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"ARCHELON\": {\r\n            \"health\": 60,\r\n            \"speed\": 0.14999998807907104,\r\n            \"attack\": 6,\r\n            \"inventorySize\": 10,\r\n            \"spawnCategory\" : \"ArchelonSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"cod\",\"salmon\"],\r\n            \"breedingItems\": [\"cod\",\"salmon\"],\r\n            \"foodItems\": [\"piscivore\"],\r\n            \"hostileToMobs\": [\"minecraft:salmon\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 75\r\n        },\r\n        \"COURIER_BIRD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"CourierBirdSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"sweet_berries\"],\r\n            \"foodItems\": [\"fruitItems\"],\r\n            \"breedingItems\": [\"sweet_berries\", \"melon_slice\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": true,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"DIREWOLF\": {\r\n            \"health\": 30,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 7,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"DireWolfSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"bone\"],\r\n            \"breedingItems\": [\"rabbit\",\"chicken\",\"mutton\",\"beef\",\"porkchop\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:sheep\",\"minecraft:skeleton\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"DRAGON\": {\r\n            \"health\": 40,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 10,\r\n            \"inventorySize\": 9,\r\n            \"spawnCategory\" : \"DragonSpawnSettings\",\r\n            \"tamingChance\": 5,\r\n            \"tamingItems\": [\"gold_ingot\",\"diamond\",\"emerald\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"breedingItems\": [\"golden_carrot\",\"golden_apple\",\"glistering_melon_slice\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"GRIFFON\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 7,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"GriffonSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"rabbit\",\"mutton\"],\r\n            \"breedingItems\": [\"rabbit\",\"mutton\"],\r\n            \"foodItems\": [\"meatItems\"],\r\n            \"hostileToMobs\": [\"minecraft:sheep\",\"minecraft:rabbit\"],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 50\r\n        },\r\n        \"GECKOTOA\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 9,\r\n            \"spawnCategory\" : \"GeckotoaSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"melon\",\"pumpkin\",\"hay_block\"],\r\n            \"foodItems\": [\"heartyHerbivore\"],\r\n            \"breedingItems\": [\"melon\",\"pumpkin\",\"hay_block\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 50,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"MOTH\": {\r\n            \"health\": 10,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 2,\r\n            \"inventorySize\": 2,\r\n            \"spawnCategory\" : \"MothSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"seekingBlocks\": [\"minecraft:torch\", \"minecraft:redstone_torch\", \"minecraft:soul_torch\"],\r\n            \"tamingItems\": [\"flowerItems\"],\r\n            \"breedingItems\": [\"sugar\",\"melon_slice\",\"glistering_melon_slice\"],\r\n            \"foodItems\": [\"nectar\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100\r\n        },\r\n        \"COLELYTRA\": {\r\n            \"health\": 14,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 2,\r\n            \"inventorySize\": 5,\r\n            \"spawnCategory\" : \"ColelytraSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"flowerItems\",\"mushroomItems\"],\r\n            \"breedingItems\": [\"mushroomItems\"],\r\n            \"foodItems\": [\"flowerItems\",\"mushroomItems\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100\r\n        },\r\n        \"NETHER_BAT\": {\r\n            \"health\": 25,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 4,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"NetherBatSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"porkchop\"],\r\n            \"breedingItems\": [\"porkchop\",\"apple\",\"rotten_flesh\"],\r\n            \"foodItems\": [\"scavenger\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"NUDIBRANCH\": {\r\n            \"health\": 25,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"NudibranchSpawnSettings\",\r\n            \"spawnBlocks\": [\"minecraft:brain_coral_block\",\"minecraft:bubble_coral_block\",\"minecraft:fire_coral_block\",\"minecraft:horn_coral_block\",\"minecraft:tube_coral_block\"],\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"seagrass\"],\r\n            \"foodItems\": [\"seaweedItems\"],\r\n            \"breedingItems\": [\"kelp\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": false,\r\n            \"loudness\": 100,\r\n            \"specialAbilitiesEnabled\": true\r\n        },\r\n        \"RIDING_LIZARD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 2,\r\n            \"spawnCategory\" : \"RidingLizardSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"rabbit\", \"chicken\"],\r\n            \"breedingItems\": [\"rabbit\", \"chicken\", \"pumpkin\", \"rotten_flesh\"],\r\n            \"foodItems\": [\"scavenger\"],\r\n            \"hostileToMobs\": [\"minecraft:rabbit\",\"minecraft:chicken\"],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"FIREBIRD\": {\r\n            \"health\": 20,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 3,\r\n            \"inventorySize\": 3,\r\n            \"spawnCategory\" : \"FirebirdSpawnSettings\",\r\n            \"tamingChance\": 10,\r\n            \"tamingItems\": [\"golden_apple\"],\r\n            \"breedingItems\": [\"golden_apple\"],\r\n            \"foodItems\": [\"golden_apple\"],\r\n            \"hostileToMobs\": [],\r\n            \"playerHostile\": false,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        },\r\n        \"NIGHTMARE\": {\r\n            \"health\": 35,\r\n            \"speed\": 0.44999998807907104,\r\n            \"attack\": 5,\r\n            \"inventorySize\": 4,\r\n            \"spawnCategory\" : \"NightmareSpawnSettings\",\r\n            \"tamingChance\": 3,\r\n            \"tamingItems\": [\"bone\", \"coal\", \"charcoal\"],\r\n            \"breedingItems\": [\"blaze_rod\",\"fire_charge\"],\r\n            \"hostileToMobs\":  [\"minecraft:skeleton\",\"minecraft:wither_skeleton\"],\r\n            \"foodItems\": [\"mushroomItems\",\"rootItems\",\"bone\", \"coal\", \"charcoal\",\"blaze_rod\",\"fire_charge\"],\r\n            \"playerHostile\": true,\r\n            \"fleeFromPlayer\": false,\r\n            \"battleWithOwner\": true,\r\n            \"loudness\": 100\r\n        }\r\n    }\r\n}");
        myWriter.close();
    }

    protected static void createMergedSettings(JsonObject newJson) throws IOException {
        FileWriter myWriter = new FileWriter(FMLPaths.CONFIGDIR.get() + File.separator + configFileName);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(newJson.toString());
        String prettyJson = gson.toJson(je);
        myWriter.write(prettyJson);
        myWriter.close();
    }

    protected static void createBackupSettingsFile(int configVersion) throws IOException {
        System.out.println("Current config file is outdated. Created backup and regenerated new config for MythicMounts mod.");
        FileWriter myWriter = new FileWriter(FMLPaths.CONFIGDIR.get() + File.separator + "MythicMountsConfig.json.backup_version" + configVersion + ".json");
        BufferedReader br = new BufferedReader(new FileReader(FMLPaths.CONFIGDIR.get() + File.separator + configFileName));
        for (Object line : br.lines().toArray()) {
            myWriter.write(line + System.lineSeparator());
        }
        myWriter.close();
        br.close();
    }

    private static InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = MythicMounts.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }
}

